/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.bytecode.bootstrap;

import de.carne.mcd.bootstrap.InstructionIndexBuilder;
import de.carne.mcd.jvmdecoder.classfile.bytecode.bootstrap.BytecodeInstructionReference;
import de.carne.mcd.jvmdecoder.classfile.bytecode.bootstrap.BytecodeInstructionReferenceEntry;
import de.carne.mcd.jvmdecoder.classfile.bytecode.bootstrap.BytecodeInstructionReferenceScraper;
import de.carne.util.Check;
import de.carne.util.Strings;
import de.carne.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class BootstrapBytecodeInstructionIndex {
    private static final Log LOG = new Log();
    private static final File INSTRUCTION_REFERENCE_FILE = new File("./src/main/resources/de/carne/mcd/jvm/classfile/bytecode/bootstrap/BytecodeInstructionReference.txt");
    private static final File INSTRUCTION_INDEX_FILE = new File("./src/main/resources/de/carne/mcd/jvm/classfile/bytecode/BytecodeInstructionIndex.bin");

    private BootstrapBytecodeInstructionIndex() {
    }

    public static void main(String[] args) {
        try {
            switch (args.length) {
                case 0: {
                    BootstrapBytecodeInstructionIndex.updateInstructionIndex();
                    break;
                }
                case 1: {
                    BootstrapBytecodeInstructionIndex.updateInstructionReferences(Objects.requireNonNull(args[0]));
                    BootstrapBytecodeInstructionIndex.updateInstructionIndex();
                    break;
                }
                default: {
                    Check.fail((String)"Invalid command line: ''{0}''", (Object[])new Object[]{Strings.join((Object[])args, (String)", ")});
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Processing failure", new Object[0]);
        }
    }

    private static void updateInstructionReferences(String source) throws IOException {
        try (BytecodeInstructionReferenceScraper scraper = BootstrapBytecodeInstructionIndex.openReference(source);){
            BytecodeInstructionReferenceEntry referenceEntry;
            BytecodeInstructionReference reference = new BytecodeInstructionReference();
            reference.load(INSTRUCTION_REFERENCE_FILE);
            while ((referenceEntry = scraper.scrapeNext()) != null) {
                reference.addOrUpdateEntry(referenceEntry);
            }
            reference.save(INSTRUCTION_REFERENCE_FILE);
            reference.logStatus();
        }
    }

    private static void updateInstructionIndex() throws IOException {
        BytecodeInstructionReference reference = new BytecodeInstructionReference();
        reference.load(INSTRUCTION_REFERENCE_FILE);
        InstructionIndexBuilder builder = new InstructionIndexBuilder();
        reference.build(builder);
        long totalIndexSize = builder.save(INSTRUCTION_INDEX_FILE);
        LOG.notice("Index entry count   : {0}", new Object[]{builder.entryCount()});
        LOG.notice("Index opcode bytes  : {0}", new Object[]{builder.opcodeBytes()});
        LOG.notice("Index position bytes: {0}", new Object[]{builder.positionBytes()});
        LOG.notice("Index size          : {0}", new Object[]{totalIndexSize});
    }

    private static BytecodeInstructionReferenceScraper openReference(String source) throws IOException {
        LOG.info("Opening reference source: ''{0}''...", new Object[]{source});
        URL referenceUrl = new URL(source);
        return new BytecodeInstructionReferenceScraper(referenceUrl.openStream(), StandardCharsets.UTF_8);
    }
}

