/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.bytecode;

import de.carne.mcd.io.MCDInputBuffer;
import de.carne.mcd.io.MCDOutputBuffer;
import de.carne.mcd.jvmdecoder.classfile.bytecode.OperandType;
import de.carne.text.HexFormat;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TableswitchOperandDecoder
implements OperandType {
    @Override
    public char type() {
        return 't';
    }

    @Override
    public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void decode(int pc, MCDInputBuffer buffer, MCDOutputBuffer out) throws IOException {
        int basePc = pc + 1;
        buffer.decodeI8Array((basePc + 3 & 0xFFFFFFFC) - basePc);
        int tsDefault = buffer.decodeI32();
        int tsLow = buffer.decodeI32();
        int tsHigh = buffer.decodeI32();
        ByteBuffer offsets = buffer.decodeI32Array(tsHigh - tsLow + 1);
        out.printComment("//");
        int index = tsLow;
        while (offsets.hasRemaining()) {
            int offset = offsets.getInt();
            out.printComment(" ").printComment(Integer.toString(index)).printComment(":").printComment(HexFormat.LOWER_CASE.format((short)(pc + offset)));
            ++index;
        }
        out.printComment(" default:").printComment(HexFormat.LOWER_CASE.format((short)(pc + tsDefault)));
    }
}

