/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.bytecode;

import de.carne.mcd.MachineCodeDecoder;
import de.carne.mcd.io.MCDInputBuffer;
import de.carne.mcd.io.MCDOutputBuffer;
import de.carne.mcd.jvmdecoder.classfile.bytecode.BytecodeDecoder;
import de.carne.mcd.jvmdecoder.classfile.bytecode.OperandType;
import de.carne.mcd.jvmdecoder.classfile.bytecode.ShortOperandDecoder;
import de.carne.text.HexFormat;
import java.io.IOException;

public enum ShortOperandType implements OperandType
{
    IMMEDIATE_VALUE((pc, operand, out) -> out.printValue(Short.toString(operand))),
    IGNORE((pc, operand, out) -> {}),
    INC_CONST((pc, operand, out) -> out.print(", ").printValue(Short.toString(operand))),
    LOCAL_VARIABLE_INDEX((pc, operand, out) -> out.printValue("local_" + Short.toUnsignedInt(operand))),
    RUNTIME_CONSTANT_INDEX((pc, operand, out) -> out.printValue("#" + Short.toUnsignedInt(operand)).print(" ").printComment("// ").printComment(ShortOperandType.runtimeConstantComment(operand))),
    BRANCH((pc, operand, out) -> out.printValue(operand >= 0 ? "+" : "").printValue(Short.toString(operand)).print(" ").printComment("// ").printComment(HexFormat.LOWER_CASE.format((short)(pc + operand))));

    private final ShortOperandDecoder decoder;

    private ShortOperandType(ShortOperandDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public char type() {
        return 'S';
    }

    @Override
    public void decode(int pc, MCDInputBuffer buffer, MCDOutputBuffer out) throws IOException {
        this.decoder.decode(pc, buffer.decodeI16(), out);
    }

    private static String runtimeConstantComment(short index) {
        return ((BytecodeDecoder)MachineCodeDecoder.getDecoder(BytecodeDecoder.class)).getClassInfo().resolveRuntimeSymbol(Short.toUnsignedInt(index));
    }
}

