/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.bytecode;

import de.carne.mcd.io.MCDInputBuffer;
import de.carne.mcd.io.MCDOutputBuffer;
import de.carne.mcd.jvmdecoder.classfile.bytecode.OperandType;
import de.carne.text.HexFormat;
import java.io.IOException;
import java.nio.ByteBuffer;

public class LookupswitchOperandDecoder
implements OperandType {
    @Override
    public char type() {
        return 'l';
    }

    @Override
    public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void decode(int pc, MCDInputBuffer buffer, MCDOutputBuffer out) throws IOException {
        int basePc = pc + 1;
        buffer.decodeI8Array((basePc + 3 & 0xFFFFFFFC) - basePc);
        int lsDefault = buffer.decodeI32();
        int lsNPairs = buffer.decodeI32();
        ByteBuffer pairs = buffer.decodeI32Array(lsNPairs * 2);
        out.printComment("//");
        while (pairs.hasRemaining()) {
            int match = pairs.getInt();
            int offset = pairs.getInt();
            out.printComment(" ").printComment(Integer.toString(match)).printComment(":").printComment(HexFormat.LOWER_CASE.format((short)(pc + offset)));
        }
        out.printComment(" default:").printComment(HexFormat.LOWER_CASE.format((short)(pc + lsDefault)));
    }
}

