/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.bytecode;

import de.carne.mcd.MachineCodeDecoder;
import de.carne.mcd.io.MCDInputBuffer;
import de.carne.mcd.io.MCDOutputBuffer;
import de.carne.mcd.jvmdecoder.classfile.bytecode.ByteOperandDecoder;
import de.carne.mcd.jvmdecoder.classfile.bytecode.BytecodeDecoder;
import de.carne.mcd.jvmdecoder.classfile.bytecode.OperandType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public enum ByteOperandType implements OperandType
{
    IMMEDIATE_VALUE((pc, operand, out) -> out.printValue(Byte.toString(operand))),
    ARRAY_TYPE((pc, operand, out) -> out.printValue(Byte.toString(operand)).print(" ").printComment("// ").printComment(ByteOperandType.arrayTypeComment(operand))),
    INC_CONST((pc, operand, out) -> out.print(", ").printValue(Byte.toString(operand))),
    DIMENSION((pc, operand, out) -> out.print(", ").printValue(Byte.toString(operand))),
    LOCAL_VARIABLE_INDEX((pc, operand, out) -> out.printValue("local_" + Byte.toUnsignedInt(operand))),
    RUNTIME_CONSTANT_INDEX((pc, operand, out) -> out.printValue("#" + Byte.toUnsignedInt(operand)).print(" ").printComment("// ").printComment(ByteOperandType.runtimeConstantComment(operand)));

    private static final Map<Byte, String> ARRAY_TYPE_COMMENTS;
    private final ByteOperandDecoder decoder;

    private ByteOperandType(ByteOperandDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public char type() {
        return 'B';
    }

    @Override
    public void decode(int pc, MCDInputBuffer buffer, MCDOutputBuffer out) throws IOException {
        this.decoder.decode(pc, buffer.decodeI8(), out);
    }

    private static String arrayTypeComment(byte arrayType) {
        return ARRAY_TYPE_COMMENTS.getOrDefault(arrayType, "?");
    }

    private static String runtimeConstantComment(byte index) {
        return ((BytecodeDecoder)MachineCodeDecoder.getDecoder(BytecodeDecoder.class)).getClassInfo().resolveRuntimeSymbol(Byte.toUnsignedInt(index));
    }

    static {
        ARRAY_TYPE_COMMENTS = new HashMap<Byte, String>();
        ARRAY_TYPE_COMMENTS.put((byte)4, "boolean[]");
        ARRAY_TYPE_COMMENTS.put((byte)5, "char[]");
        ARRAY_TYPE_COMMENTS.put((byte)6, "float[]");
        ARRAY_TYPE_COMMENTS.put((byte)7, "couble[]");
        ARRAY_TYPE_COMMENTS.put((byte)8, "byte[]");
        ARRAY_TYPE_COMMENTS.put((byte)9, "short[]");
        ARRAY_TYPE_COMMENTS.put((byte)10, "int[]");
        ARRAY_TYPE_COMMENTS.put((byte)11, "long[]");
    }
}

