/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.attribute.module;

import de.carne.mcd.jvmdecoder.classfile.ClassContext;
import de.carne.mcd.jvmdecoder.classfile.ClassInfo;
import de.carne.mcd.jvmdecoder.classfile.ClassInfoElement;
import de.carne.mcd.jvmdecoder.classfile.ClassPrinter;
import de.carne.mcd.jvmdecoder.classfile.constant.ClassConstant;
import de.carne.mcd.jvmdecoder.classfile.constant.ModuleConstant;
import de.carne.mcd.jvmdecoder.classfile.constant.PackageConstant;
import de.carne.mcd.jvmdecoder.classfile.constant.Utf8Constant;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ModuleInfoElement
extends ClassInfoElement {
    private static final Map<Integer, String> FLAG_COMMENT_SYMBOLS = new LinkedHashMap<Integer, String>();
    private static final Map<Integer, String> REQUIRES_FLAG_KEYWORD_SYMBOLS;

    ModuleInfoElement(ClassInfo classInfo) {
        super(classInfo);
    }

    public static ModuleInfoElement requires(ClassInfo classInfo, final int requiresIndex, final int requiresFlags, final int requiresVersionIndex) {
        return new ModuleInfoElement(classInfo){

            @Override
            public void print(ClassPrinter out, ClassContext context) throws IOException {
                out.printKeyword("requires").print(" ");
                out.printFlagsComment(FLAG_COMMENT_SYMBOLS, requiresFlags);
                out.printFlagsKeyword(REQUIRES_FLAG_KEYWORD_SYMBOLS, requiresFlags);
                this.classInfo.resolveConstant(requiresIndex, ModuleConstant.class).print(out, context);
                if (requiresVersionIndex != 0) {
                    String versionValue = this.classInfo.resolveConstant(requiresVersionIndex, Utf8Constant.class).getValue();
                    out.print(" ").printComment("/* ").printComment(versionValue).printComment(" */");
                }
                out.println(";");
            }
        };
    }

    public static ModuleInfoElement exports(ClassInfo classInfo, final int exportsIndex, final int exportsFlags, final int[] exportsToIndexes) {
        return new ModuleInfoElement(classInfo){

            @Override
            public void print(ClassPrinter out, ClassContext context) throws IOException {
                out.printKeyword("exports").print(" ");
                out.printFlagsComment(FLAG_COMMENT_SYMBOLS, exportsFlags);
                this.classInfo.resolveConstant(exportsIndex, PackageConstant.class).print(out, context);
                if (exportsToIndexes.length > 0) {
                    out.print(" ").printKeyword("to").println();
                    out.output().increaseIndent();
                    for (int exportsToIndex : exportsToIndexes) {
                        this.classInfo.resolveConstant(exportsToIndex, ModuleConstant.class).print(out, context);
                        if (exportsToIndex >= exportsToIndexes.length) continue;
                        out.println(",");
                    }
                    out.output().decreaseIndent();
                }
                out.println(";");
            }
        };
    }

    public static ModuleInfoElement opens(ClassInfo classInfo, final int opensIndex, final int opensFlags, final int[] opensToIndexes) {
        return new ModuleInfoElement(classInfo){

            @Override
            public void print(ClassPrinter out, ClassContext context) throws IOException {
                out.printKeyword("opens").print(" ");
                out.printFlagsComment(FLAG_COMMENT_SYMBOLS, opensFlags);
                this.classInfo.resolveConstant(opensIndex, PackageConstant.class).print(out, context);
                if (opensToIndexes.length > 0) {
                    out.print(" ").printKeyword("to").println();
                    out.output().increaseIndent();
                    for (int opensToIndex : opensToIndexes) {
                        this.classInfo.resolveConstant(opensToIndex, ModuleConstant.class).print(out, context);
                        if (opensToIndex >= opensToIndexes.length) continue;
                        out.println(",");
                    }
                    out.output().decreaseIndent();
                }
                out.println(";");
            }
        };
    }

    public static ModuleInfoElement uses(ClassInfo classInfo, final int usesIndex) {
        return new ModuleInfoElement(classInfo){

            @Override
            public void print(ClassPrinter out, ClassContext context) throws IOException {
                out.printKeyword("uses").print(" ");
                this.classInfo.resolveConstant(usesIndex, ClassConstant.class).print(out, context);
                out.println(";");
            }
        };
    }

    public static ModuleInfoElement provides(ClassInfo classInfo, final int providesIndex, final int[] providesWithIndexes) {
        return new ModuleInfoElement(classInfo){

            @Override
            public void print(ClassPrinter out, ClassContext context) throws IOException {
                out.printKeyword("provides").print(" ");
                this.classInfo.resolveConstant(providesIndex, ClassConstant.class).print(out, context);
                if (providesWithIndexes.length > 0) {
                    out.print(" ").printKeyword("with").println();
                    out.output().increaseIndent();
                    for (int providesWithIndex : providesWithIndexes) {
                        this.classInfo.resolveConstant(providesWithIndex, ClassConstant.class).print(out, context);
                        if (providesWithIndex >= providesWithIndexes.length) continue;
                        out.println(",");
                    }
                    out.output().decreaseIndent();
                }
                out.println(";");
            }
        };
    }

    static {
        FLAG_COMMENT_SYMBOLS.put(4096, "synthetic");
        FLAG_COMMENT_SYMBOLS.put(32768, "mandated");
        REQUIRES_FLAG_KEYWORD_SYMBOLS = new LinkedHashMap<Integer, String>();
        REQUIRES_FLAG_KEYWORD_SYMBOLS.put(32, "transitive");
        REQUIRES_FLAG_KEYWORD_SYMBOLS.put(64, "static");
    }
}

