/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.attribute.annotation;

import java.io.IOException;

public abstract class TypeAnnotationTarget {
    private final int targetType;

    protected TypeAnnotationTarget(int targetType) {
        this.targetType = targetType;
    }

    public int type() {
        return this.targetType;
    }

    public TypeParameter typeParameter() throws IOException {
        throw this.targetTypeMismatch(TypeParameter.class);
    }

    public Supertype supertype() throws IOException {
        throw this.targetTypeMismatch(Supertype.class);
    }

    public TypeParameterBound typeParameterBound() throws IOException {
        throw this.targetTypeMismatch(TypeParameterBound.class);
    }

    public FormalParameter formalParameter() throws IOException {
        throw this.targetTypeMismatch(FormalParameter.class);
    }

    public ThrowsType throwsType() throws IOException {
        throw this.targetTypeMismatch(ThrowsType.class);
    }

    public Localvar localvar() throws IOException {
        throw this.targetTypeMismatch(Localvar.class);
    }

    public CatchType catchType() throws IOException {
        throw this.targetTypeMismatch(CatchType.class);
    }

    public Offset offset() throws IOException {
        throw this.targetTypeMismatch(Offset.class);
    }

    public TypeArgument typeArgument() throws IOException {
        throw this.targetTypeMismatch(TypeArgument.class);
    }

    private IOException targetTypeMismatch(Class<? extends TypeAnnotationTarget> targetClass) {
        return new IOException("Target type " + this.targetType + " does not match " + targetClass.getSimpleName() + " target info");
    }

    public static class TypeArgument
    extends TypeAnnotationTarget {
        private final int offset;
        private final int argumentIndex;

        public TypeArgument(int targetType, int offset, int argumentIndex) {
            super(targetType);
            this.offset = offset;
            this.argumentIndex = argumentIndex;
        }
    }

    public static class Offset
    extends TypeAnnotationTarget {
        private final int offset;

        public Offset(int targetType, int offset) {
            super(targetType);
            this.offset = offset;
        }
    }

    public static class CatchType
    extends TypeAnnotationTarget {
        private final int exceptionIndex;

        public CatchType(int targetType, int exceptionIndex) {
            super(targetType);
            this.exceptionIndex = exceptionIndex;
        }
    }

    public static class Localvar
    extends TypeAnnotationTarget {
        private final short[] table;

        public Localvar(int targetType, short[] table) {
            super(targetType);
            this.table = table;
        }
    }

    public static class ThrowsType
    extends TypeAnnotationTarget {
        private final int throwsIndex;

        public ThrowsType(int targetType, int throwsIndex) {
            super(targetType);
            this.throwsIndex = throwsIndex;
        }
    }

    public static class FormalParameter
    extends TypeAnnotationTarget {
        private final int parameterIndex;

        public FormalParameter(int targetType, int parameterIndex) {
            super(targetType);
            this.parameterIndex = parameterIndex;
        }
    }

    public static class TypeParameterBound
    extends TypeAnnotationTarget {
        private final int parameterIndex;
        private final int boundIndex;

        public TypeParameterBound(int targetType, int parameterIndex, int boundIndex) {
            super(targetType);
            this.parameterIndex = parameterIndex;
            this.boundIndex = boundIndex;
        }
    }

    public static class Supertype
    extends TypeAnnotationTarget {
        private final int supertypeIndex;

        public Supertype(int targetType, int supertypeIndex) {
            super(targetType);
            this.supertypeIndex = supertypeIndex;
        }
    }

    public static class TypeParameter
    extends TypeAnnotationTarget {
        private final int parameterIndex;

        public TypeParameter(int targetType, int parameterIndex) {
            super(targetType);
            this.parameterIndex = parameterIndex;
        }

        public int parameterIndex() {
            return this.parameterIndex;
        }

        @Override
        public TypeParameter typeParameter() throws IOException {
            return this;
        }
    }

    public static class Empty
    extends TypeAnnotationTarget {
        public Empty(int targetType) {
            super(targetType);
        }
    }
}

