/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.attribute;

import de.carne.mcd.jvmdecoder.classfile.ClassContext;
import de.carne.mcd.jvmdecoder.classfile.ClassInfo;
import de.carne.mcd.jvmdecoder.classfile.ClassPrinter;
import de.carne.mcd.jvmdecoder.classfile.attribute.Attribute;
import de.carne.mcd.jvmdecoder.classfile.attribute.module.ModuleInfoElement;
import de.carne.mcd.jvmdecoder.classfile.constant.ModuleConstant;
import de.carne.mcd.jvmdecoder.classfile.constant.Utf8Constant;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModuleAttribute
extends Attribute {
    public static final String NAME = "Module";
    private static final Map<Integer, String> MODULE_FLAG_SYMBOLS = new LinkedHashMap<Integer, String>();
    private final int moduleNameIndex;
    private final int moduleFlags;
    private final int moduleVersionIndex;
    private List<ModuleInfoElement> elements;

    public ModuleAttribute(ClassInfo classInfo, int moduleNameIndex, int moduleFlags, int moduleVersionIndex, List<ModuleInfoElement> elements) {
        super(classInfo);
        this.moduleNameIndex = moduleNameIndex;
        this.moduleFlags = moduleFlags;
        this.moduleVersionIndex = moduleVersionIndex;
        this.elements = Collections.unmodifiableList(elements);
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        out.printKeyword("module").print(" ");
        out.printFlagsComment(MODULE_FLAG_SYMBOLS, this.moduleFlags);
        this.classInfo.resolveConstant(this.moduleNameIndex, ModuleConstant.class).print(out, context);
        if (this.moduleVersionIndex != 0) {
            String versionValue = this.classInfo.resolveConstant(this.moduleVersionIndex, Utf8Constant.class).getValue();
            out.print(" ").printComment("/* ").printComment(versionValue).printComment(" */");
        }
        out.println(" {");
        out.output().increaseIndent();
        for (ModuleInfoElement element : this.elements) {
            element.print(out, context);
        }
        out.output().decreaseIndent();
        out.println("}");
    }

    static {
        MODULE_FLAG_SYMBOLS.put(32, "open");
        MODULE_FLAG_SYMBOLS.put(4096, "synthetic");
        MODULE_FLAG_SYMBOLS.put(32768, "mandated");
    }
}

