/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile;

import de.carne.mcd.jvmdecoder.classfile.ClassContext;
import de.carne.mcd.jvmdecoder.classfile.ClassInfo;
import de.carne.mcd.jvmdecoder.classfile.ClassInfoElement;
import de.carne.mcd.jvmdecoder.classfile.ClassPrinter;
import de.carne.mcd.jvmdecoder.classfile.MethodInfo;
import de.carne.mcd.jvmdecoder.classfile.NameDescriptorIndex;
import de.carne.mcd.jvmdecoder.classfile.attribute.Attribute;
import de.carne.mcd.jvmdecoder.classfile.constant.Utf8Constant;
import de.carne.util.Check;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

class Method
extends ClassInfoElement
implements MethodInfo {
    private final int accessFlags;
    private final NameDescriptorIndex nameDescriptorIndex;
    private final List<Attribute> attributes;

    Method(ClassInfo classInfo, int accessFlags, int nameIndex, int descriptorIndex, List<Attribute> attributes) {
        super(classInfo);
        this.accessFlags = accessFlags;
        this.nameDescriptorIndex = new NameDescriptorIndex(nameIndex, descriptorIndex);
        this.attributes = Collections.unmodifiableList(attributes);
    }

    @Override
    public int accessFlags() {
        return this.accessFlags;
    }

    @Override
    public String descriptor() throws IOException {
        return this.classInfo.resolveConstant(this.nameDescriptorIndex.descriptorIndex(), Utf8Constant.class).getValue();
    }

    @Override
    public String name() throws IOException {
        return this.classInfo.resolveConstant(this.nameDescriptorIndex.nameIndex(), Utf8Constant.class).getValue();
    }

    @Override
    public List<Attribute> attributes() {
        return this.attributes;
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        Check.fail();
    }

    public String toString() {
        return this.nameDescriptorIndex.toString();
    }
}

