/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile;

import de.carne.mcd.io.MCDOutputBuffer;
import de.carne.mcd.jvmdecoder.classfile.ClassContext;
import de.carne.mcd.jvmdecoder.classfile.ClassInfo;
import de.carne.mcd.jvmdecoder.classfile.ClassName;
import de.carne.mcd.jvmdecoder.classfile.ClassUtil;
import de.carne.mcd.jvmdecoder.classfile.FieldInfo;
import de.carne.mcd.jvmdecoder.classfile.MethodInfo;
import de.carne.mcd.jvmdecoder.classfile.PrintBuffer;
import de.carne.mcd.jvmdecoder.classfile.PrintSeparator;
import de.carne.mcd.jvmdecoder.classfile.attribute.Attribute;
import de.carne.mcd.jvmdecoder.classfile.attribute.Attributes;
import de.carne.mcd.jvmdecoder.classfile.attribute.CodeAttribute;
import de.carne.mcd.jvmdecoder.classfile.attribute.ConstantValueAttribute;
import de.carne.mcd.jvmdecoder.classfile.attribute.ExceptionsAttribute;
import de.carne.mcd.jvmdecoder.classfile.attribute.ModuleAttribute;
import de.carne.mcd.jvmdecoder.classfile.attribute.RuntimeAnnotationsAttribute;
import de.carne.mcd.jvmdecoder.classfile.attribute.SignatureAttribute;
import de.carne.mcd.jvmdecoder.classfile.attribute.SourceFileAttribute;
import de.carne.mcd.jvmdecoder.classfile.decl.DeclDecoder;
import de.carne.mcd.jvmdecoder.classfile.decl.DecodedClassSignature;
import de.carne.mcd.jvmdecoder.classfile.decl.DecodedFieldDescriptor;
import de.carne.mcd.jvmdecoder.classfile.decl.DecodedFieldSignature;
import de.carne.mcd.jvmdecoder.classfile.decl.DecodedMethodDescriptor;
import de.carne.mcd.jvmdecoder.classfile.decl.DecodedMethodSignature;
import de.carne.util.Strings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class ClassPrinter {
    public static final String S_MODULE = "module";
    public static final String S_PACKAGE = "package";
    public static final String S_CLASS = "class";
    public static final String S_INTERFACE = "interface";
    public static final String S_ENUM = "enum";
    public static final String S_ANNOTATION = "@interface";
    public static final String S_REQUIRES = "requires";
    public static final String S_EXPORTS = "exports";
    public static final String S_OPENS = "opens";
    public static final String S_TO = "to";
    public static final String S_USES = "uses";
    public static final String S_PROVIDES = "provides";
    public static final String S_WITH = "with";
    public static final String S_SUPER = "super";
    public static final String S_EXTENDS = "extends";
    public static final String S_IMPLEMENTS = "implements";
    public static final String S_THROWS = "throws";
    public static final String S_PUBLIC = "public";
    public static final String S_PRIVATE = "private";
    public static final String S_PROTECTED = "protected";
    public static final String S_STATIC = "static";
    public static final String S_FINAL = "final";
    public static final String S_VOLATILE = "volatile";
    public static final String S_TRANSIENT = "transient";
    public static final String S_BRIDGE = "bridge";
    public static final String S_VARARGS = "varargs";
    public static final String S_SYNTHETIC = "synthetic";
    public static final String S_TRANSITIVE = "transitive";
    public static final String S_OPEN = "open";
    public static final String S_MANDATED = "mandated";
    public static final String S_SYNCHRONIZED = "synchronized";
    public static final String S_NATIVE = "native";
    public static final String S_ABSTRACT = "abstract";
    public static final String S_BYTE = "byte";
    public static final String S_CHAR = "char";
    public static final String S_DOUBLE = "double";
    public static final String S_FLOAT = "float";
    public static final String S_INT = "int";
    public static final String S_LONG = "long";
    public static final String S_SHORT = "short";
    public static final String S_BOOLEAN = "boolean";
    public static final String S_VOID = "void";
    public static final String S_DEPRECATED = "@Deprecated";
    protected final MCDOutputBuffer out;
    protected final ClassInfo classInfo;
    protected final String classPackage;
    private static final Map<Integer, String> CLASS_ACCESS_FLAG_KEYWORD_SYMBOLS = new LinkedHashMap<Integer, String>();
    private static final Map<Integer, String> CLASS_ACCESS_FLAG_COMMENT_SYMBOLS;
    private static final Map<Integer, String> FIELD_ACCESS_FLAG_KEYWORD_SYMBOLS;
    private static final Map<Integer, String> FIELD_ACCESS_FLAG_COMMENT_SYMBOLS;
    private static final Map<Integer, String> METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS;
    private static final Map<Integer, String> METHOD_ACCESS_FLAG_COMMENT_SYMBOLS;

    protected ClassPrinter(MCDOutputBuffer out, ClassInfo classInfo) {
        this.out = out;
        this.classInfo = classInfo;
        this.classPackage = this.classInfo.thisClass().getPackageName();
    }

    public static ClassPrinter getInstance(MCDOutputBuffer out, ClassInfo classInfo) {
        ClassPrinter classPrinter = ClassUtil.isPackageInfo(classInfo) ? new PackageInfoClassPrinter(out, classInfo) : (ClassUtil.isModuleInfo(classInfo) ? new ModuleInfoClassPrinter(out, classInfo) : (ClassUtil.isInterface(classInfo) ? new InterfaceClassPrinter(out, classInfo) : (ClassUtil.isAnnotation(classInfo) ? new AnnotationClassPrinter(out, classInfo) : (ClassUtil.isEnum(classInfo) ? new EnumClassPrinter(out, classInfo) : new DefaultClassPrinter(out, classInfo)))));
        return classPrinter;
    }

    public MCDOutputBuffer output() {
        return this.out;
    }

    public abstract void print() throws IOException;

    public ClassPrinter println() throws IOException {
        this.out.println();
        return this;
    }

    public ClassPrinter print(String text) throws IOException {
        this.out.print(text);
        return this;
    }

    public ClassPrinter println(String text) throws IOException {
        this.out.println(text);
        return this;
    }

    public ClassPrinter printValue(String value) throws IOException {
        this.out.printValue(value);
        return this;
    }

    public ClassPrinter printlnValue(String value) throws IOException {
        this.out.printlnValue(value);
        return this;
    }

    public ClassPrinter printComment(String comment) throws IOException {
        this.out.printComment(comment);
        return this;
    }

    public ClassPrinter printlnComment(String comment) throws IOException {
        this.out.printlnComment(comment);
        return this;
    }

    public ClassPrinter printKeyword(String keyword) throws IOException {
        this.out.printKeyword(keyword);
        return this;
    }

    public ClassPrinter printlnKeyword(String keyword) throws IOException {
        this.out.printlnKeyword(keyword);
        return this;
    }

    public ClassPrinter printOperator(String operator) throws IOException {
        this.out.printOperator(operator);
        return this;
    }

    public ClassPrinter printlnOperator(String operator) throws IOException {
        this.out.printlnOperator(operator);
        return this;
    }

    public ClassPrinter printLabel(String label) throws IOException {
        this.out.printLabel(label);
        return this;
    }

    public ClassPrinter printlnLabel(String label) throws IOException {
        this.out.printlnLabel(label);
        return this;
    }

    public void printFlagsComment(Map<Integer, String> flagSymbols, int flags) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<Integer, String> commentEntry : flagSymbols.entrySet()) {
            int flag = commentEntry.getKey();
            String keyword = commentEntry.getValue();
            if ((flags & flag) != flag) continue;
            buffer.append(buffer.length() == 0 ? "/* " : "|").append(keyword);
        }
        if (buffer.length() > 0) {
            buffer.append(" */");
            this.out.printComment(buffer.toString()).print(" ");
        }
    }

    public void printFlagsKeyword(Map<Integer, String> flagSymbols, int flags) throws IOException {
        for (Map.Entry<Integer, String> keywordEntry : flagSymbols.entrySet()) {
            int flag = keywordEntry.getKey();
            String keyword = keywordEntry.getValue();
            if ((flags & flag) != flag) continue;
            this.out.printKeyword(keyword).print(" ");
        }
    }

    protected void printClassComment() throws IOException {
        this.out.printlnComment("/*");
        int major = this.classInfo.majorVersion();
        int minor = this.classInfo.minorVersion();
        this.out.printlnComment(" * Class file version: " + major + "." + minor);
        Optional<SourceFileAttribute> optionalSourceFileAttribute = Attributes.resolveOptionalAttribute(this.classInfo.attributes(), SourceFileAttribute.class);
        if (optionalSourceFileAttribute.isPresent()) {
            String sourceFile = optionalSourceFileAttribute.get().getValue();
            this.out.printlnComment(" *");
            this.out.printlnComment(" * Source file: " + sourceFile);
        }
        this.out.printlnComment(" */");
    }

    protected void printClassPackage() throws IOException {
        if (Strings.notEmpty((String)this.classPackage)) {
            this.out.printKeyword(S_PACKAGE).print(" ").print(this.classPackage).println(";");
        }
    }

    protected void printClassAnnotation() throws IOException {
        this.printAnnotations(this.classInfo.attributes(), ClassContext.CLASS);
    }

    protected void printAnnotations(List<Attribute> attributes, ClassContext context) throws IOException {
        Attributes.print(Attributes.resolveAttributes(attributes, RuntimeAnnotationsAttribute.class), this, context);
    }

    protected void printModuleInfo() throws IOException {
        Attributes.resolveUniqueAttribute(this.classInfo.attributes(), ModuleAttribute.class).print(this, ClassContext.CLASS);
    }

    protected void printClassSignature(String classKeyword) throws IOException {
        this.printClassAccessFlagsKeywords();
        this.printClassAccessFlagsComment();
        this.out.printKeyword(classKeyword).print(" ").print(this.classInfo.thisClass().getEffectiveName(this.classPackage));
        Optional<SignatureAttribute> signature = Attributes.resolveOptionalAttribute(this.classInfo.attributes(), SignatureAttribute.class);
        if (signature.isPresent()) {
            DecodedClassSignature decodedSignature = DeclDecoder.decodeClassSignature(signature.get().getValue(), this.classInfo.thisClass().getPackageName());
            this.printTypeParameters(decodedSignature.typeParameters(), ClassContext.CLASS);
            this.printClassExtends(decodedSignature.superClass());
            this.printClassImplements(decodedSignature.superInterfaces());
        } else {
            this.printClassExtends();
            this.printClassImplements();
        }
    }

    private void printTypeParameters(List<PrintBuffer> typeParameters, ClassContext context) throws IOException {
        if (!typeParameters.isEmpty()) {
            PrintSeparator separator = new PrintSeparator();
            this.out.print("<");
            for (PrintBuffer typeParameter : typeParameters) {
                separator.print(this, context);
                typeParameter.print(this, context);
            }
            this.out.print(">");
        }
    }

    private void printClassExtends(PrintBuffer superClass) throws IOException {
        if (!superClass.isEmpty()) {
            this.out.print(" ").printKeyword(S_EXTENDS).print(" ");
            superClass.print(this, ClassContext.CLASS);
        }
    }

    private void printClassExtends() throws IOException {
        ClassName superClass = this.classInfo.superClass();
        if (!superClass.isObject()) {
            this.out.print(" ").printKeyword(S_EXTENDS).print(" ");
            this.out.print(superClass.getEffectiveName(this.classPackage));
        }
    }

    private void printClassImplements(List<PrintBuffer> superInterfaces) throws IOException {
        if (!superInterfaces.isEmpty()) {
            boolean interfaceClass = ClassUtil.isInterface(this.classInfo.accessFlags());
            this.out.print(" ").printKeyword(interfaceClass ? S_EXTENDS : S_IMPLEMENTS).print(" ");
            PrintSeparator separator = new PrintSeparator();
            for (PrintBuffer superInterface : superInterfaces) {
                separator.print(this, ClassContext.CLASS);
                superInterface.print(this, ClassContext.CLASS);
            }
        }
    }

    private void printClassImplements() throws IOException {
        List<ClassName> interfaces = this.classInfo.interfaces();
        if (!interfaces.isEmpty()) {
            boolean interfaceClass = ClassUtil.isInterface(this.classInfo.accessFlags());
            this.out.print(" ").printKeyword(interfaceClass ? S_EXTENDS : S_IMPLEMENTS).print(" ");
            PrintSeparator separator = new PrintSeparator();
            for (ClassName interfaceName : interfaces) {
                separator.print(this, ClassContext.CLASS);
                this.out.print(interfaceName.getEffectiveName(this.classPackage));
            }
        }
    }

    private void printClassAccessFlagsKeywords() throws IOException {
        int maskedAccessFlags = this.classInfo.accessFlags();
        if (ClassUtil.isInterface(maskedAccessFlags) || ClassUtil.isAnnotation(maskedAccessFlags)) {
            maskedAccessFlags &= 0xFFFFFBFF;
        }
        this.printFlagsKeyword(CLASS_ACCESS_FLAG_KEYWORD_SYMBOLS, maskedAccessFlags);
    }

    private void printClassAccessFlagsComment() throws IOException {
        this.printFlagsComment(CLASS_ACCESS_FLAG_COMMENT_SYMBOLS, this.classInfo.accessFlags());
    }

    private void printFieldAccessFLagsKeywords(int accessFlags) throws IOException {
        this.printFlagsKeyword(FIELD_ACCESS_FLAG_KEYWORD_SYMBOLS, accessFlags);
    }

    private void printFieldAccessFlagsComment(int accessFlags) throws IOException {
        this.printFlagsComment(FIELD_ACCESS_FLAG_COMMENT_SYMBOLS, accessFlags);
    }

    private void printMethodAccessFLagsKeywords(int accessFlags) throws IOException {
        int maskedAccessFlags = accessFlags;
        int classAccessFlags = this.classInfo.accessFlags();
        if (ClassUtil.isInterface(classAccessFlags)) {
            maskedAccessFlags &= 0xFFFFFBFF;
        }
        this.printFlagsKeyword(METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS, maskedAccessFlags);
    }

    private void printMethodAccessFLagsComment(int accessFlags) throws IOException {
        this.printFlagsComment(METHOD_ACCESS_FLAG_COMMENT_SYMBOLS, accessFlags);
    }

    protected void printFields() throws IOException {
        this.out.increaseIndent();
        for (FieldInfo field : this.classInfo.fields()) {
            this.printField(field);
        }
        this.out.decreaseIndent();
    }

    private void printField(FieldInfo field) throws IOException {
        this.out.println();
        this.printAnnotations(field.attributes(), ClassContext.FIELD);
        this.printFieldAccessFLagsKeywords(field.accessFlags());
        this.printFieldAccessFlagsComment(field.accessFlags());
        Optional<SignatureAttribute> signature = Attributes.resolveOptionalAttribute(field.attributes(), SignatureAttribute.class);
        if (signature.isPresent()) {
            DecodedFieldSignature decodedSignature = DeclDecoder.decodeFieldSignature(signature.get().getValue(), this.classPackage);
            decodedSignature.type().print(this, ClassContext.FIELD);
        } else {
            DecodedFieldDescriptor decodedDescriptor = DeclDecoder.decodeFieldDescriptor(field.descriptor(), this.classPackage);
            decodedDescriptor.type().print(this, ClassContext.FIELD);
        }
        this.out.print(" ").print(field.name());
        Optional<ConstantValueAttribute> optionalValue = Attributes.resolveOptionalAttribute(field.attributes(), ConstantValueAttribute.class);
        if (optionalValue.isPresent()) {
            this.out.print(" ").printOperator("=").print(" ");
            optionalValue.get().print(this, ClassContext.FIELD);
        }
        this.out.println(";");
    }

    protected void printMethods() throws IOException {
        this.out.increaseIndent();
        for (MethodInfo method : this.classInfo.methods()) {
            this.printMethod(method);
        }
        this.out.decreaseIndent();
    }

    private void printMethod(MethodInfo method) throws IOException {
        this.out.println();
        this.printAnnotations(method.attributes(), ClassContext.METHOD);
        this.printMethodAccessFLagsKeywords(method.accessFlags());
        this.printMethodAccessFLagsComment(method.accessFlags());
        Optional<SignatureAttribute> signature = Attributes.resolveOptionalAttribute(method.attributes(), SignatureAttribute.class);
        if (signature.isPresent()) {
            DecodedMethodSignature decodedSignature = DeclDecoder.decodeMethodSignature(signature.get().getValue(), this.classPackage);
            decodedSignature.returnType().print(this, ClassContext.METHOD);
            this.out.print(" ").print(method.name());
            this.printTypeParameters(decodedSignature.typeParameters(), ClassContext.METHOD);
            this.out.print("(");
            PrintSeparator separator = new PrintSeparator();
            for (PrintBuffer printBuffer : decodedSignature.parameterTypes()) {
                separator.print(this, ClassContext.METHOD);
                printBuffer.print(this, ClassContext.METHOD);
            }
            this.out.print(")");
            List<PrintBuffer> throwsTypes = decodedSignature.throwsTypes();
            if (!throwsTypes.isEmpty()) {
                this.out.print(" ").printKeyword(S_THROWS).print(" ");
                separator.reset();
                for (PrintBuffer throwsType : throwsTypes) {
                    separator.print(this, ClassContext.METHOD);
                    throwsType.print(this, ClassContext.METHOD);
                }
            } else {
                Attributes.print(Attributes.resolveOptionalAttribute(method.attributes(), ExceptionsAttribute.class), this, ClassContext.METHOD);
            }
        } else {
            DecodedMethodDescriptor decodedDescriptor = DeclDecoder.decodeMethodDescriptor(method.descriptor(), this.classPackage);
            decodedDescriptor.returnType().print(this, ClassContext.METHOD);
            this.out.print(" ").print(method.name()).print("(");
            PrintSeparator separator = new PrintSeparator();
            for (PrintBuffer printBuffer : decodedDescriptor.parameterTypes()) {
                separator.print(this, ClassContext.METHOD);
                printBuffer.print(this, ClassContext.METHOD);
            }
            this.out.print(")");
            Attributes.print(Attributes.resolveOptionalAttribute(method.attributes(), ExceptionsAttribute.class), this, ClassContext.METHOD);
        }
        Optional<CodeAttribute> optionalCode = Attributes.resolveOptionalAttribute(method.attributes(), CodeAttribute.class);
        if (optionalCode.isPresent()) {
            this.out.println(" {");
            this.out.increaseIndent();
            optionalCode.get().print(this, ClassContext.METHOD);
            this.out.decreaseIndent();
            this.out.println("}");
        } else {
            this.out.println(";");
        }
    }

    static {
        CLASS_ACCESS_FLAG_KEYWORD_SYMBOLS.put(1, S_PUBLIC);
        CLASS_ACCESS_FLAG_KEYWORD_SYMBOLS.put(16, S_FINAL);
        CLASS_ACCESS_FLAG_KEYWORD_SYMBOLS.put(1024, S_ABSTRACT);
        CLASS_ACCESS_FLAG_COMMENT_SYMBOLS = new LinkedHashMap<Integer, String>();
        CLASS_ACCESS_FLAG_COMMENT_SYMBOLS.put(32, S_SUPER);
        CLASS_ACCESS_FLAG_COMMENT_SYMBOLS.put(4096, S_SYNTHETIC);
        FIELD_ACCESS_FLAG_KEYWORD_SYMBOLS = new LinkedHashMap<Integer, String>();
        FIELD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(1, S_PUBLIC);
        FIELD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(2, S_PRIVATE);
        FIELD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(4, S_PROTECTED);
        FIELD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(8, S_STATIC);
        FIELD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(16, S_FINAL);
        FIELD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(64, S_VOLATILE);
        FIELD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(128, S_TRANSIENT);
        FIELD_ACCESS_FLAG_COMMENT_SYMBOLS = new LinkedHashMap<Integer, String>();
        FIELD_ACCESS_FLAG_COMMENT_SYMBOLS.put(4096, S_SYNTHETIC);
        FIELD_ACCESS_FLAG_COMMENT_SYMBOLS.put(16384, S_ENUM);
        METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS = new LinkedHashMap<Integer, String>();
        METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(1, S_PUBLIC);
        METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(2, S_PRIVATE);
        METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(4, S_PROTECTED);
        METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(8, S_STATIC);
        METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(16, S_FINAL);
        METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(32, S_SYNCHRONIZED);
        METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(256, S_NATIVE);
        METHOD_ACCESS_FLAG_KEYWORD_SYMBOLS.put(1024, S_ABSTRACT);
        METHOD_ACCESS_FLAG_COMMENT_SYMBOLS = new LinkedHashMap<Integer, String>();
        METHOD_ACCESS_FLAG_COMMENT_SYMBOLS.put(64, S_BRIDGE);
        METHOD_ACCESS_FLAG_COMMENT_SYMBOLS.put(128, S_VARARGS);
        METHOD_ACCESS_FLAG_COMMENT_SYMBOLS.put(4096, S_SYNTHETIC);
    }

    private static class DefaultClassPrinter
    extends ClassPrinter {
        DefaultClassPrinter(MCDOutputBuffer out, ClassInfo classInfo) {
            super(out, classInfo);
        }

        @Override
        public void print() throws IOException {
            this.printClassComment();
            this.printClassPackage();
            this.out.println();
            this.printClassAnnotation();
            this.printClassSignature(ClassPrinter.S_CLASS);
            this.out.println(" {");
            this.printFields();
            this.printMethods();
            this.out.println().println("}");
        }
    }

    private static class EnumClassPrinter
    extends ClassPrinter {
        EnumClassPrinter(MCDOutputBuffer out, ClassInfo classInfo) {
            super(out, classInfo);
        }

        @Override
        public void print() throws IOException {
            this.printClassComment();
            this.printClassPackage();
            this.out.println();
            this.printClassAnnotation();
            this.printClassSignature(ClassPrinter.S_ENUM);
            this.out.println(" {");
            this.printFields();
            this.printMethods();
            this.out.println().println("}");
        }
    }

    private static class AnnotationClassPrinter
    extends ClassPrinter {
        AnnotationClassPrinter(MCDOutputBuffer out, ClassInfo classInfo) {
            super(out, classInfo);
        }

        @Override
        public void print() throws IOException {
            this.printClassComment();
            this.printClassPackage();
            this.out.println();
            this.printClassAnnotation();
            this.printClassSignature(ClassPrinter.S_ANNOTATION);
            this.out.println(" {");
            this.printFields();
            this.printMethods();
            this.out.println().println("}");
        }
    }

    private static class InterfaceClassPrinter
    extends ClassPrinter {
        InterfaceClassPrinter(MCDOutputBuffer out, ClassInfo classInfo) {
            super(out, classInfo);
        }

        @Override
        public void print() throws IOException {
            this.printClassComment();
            this.printClassPackage();
            this.out.println();
            this.printClassAnnotation();
            this.printClassSignature(ClassPrinter.S_INTERFACE);
            this.out.println(" {");
            this.printFields();
            this.printMethods();
            this.out.println().println("}");
        }
    }

    private static class ModuleInfoClassPrinter
    extends ClassPrinter {
        ModuleInfoClassPrinter(MCDOutputBuffer out, ClassInfo classInfo) {
            super(out, classInfo);
        }

        @Override
        public void print() throws IOException {
            this.printClassComment();
            this.printClassAnnotation();
            this.printModuleInfo();
        }
    }

    private static class PackageInfoClassPrinter
    extends ClassPrinter {
        PackageInfoClassPrinter(MCDOutputBuffer out, ClassInfo classInfo) {
            super(out, classInfo);
        }

        @Override
        public void print() throws IOException {
            this.printClassComment();
            this.printClassAnnotation();
            this.printClassPackage();
        }
    }
}

