/*
 * Copyright (c) 2019-2021 Holger de Carne and contributors, All Rights Reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package de.carne.mcd.jvmdecoder.classfile.constant;

import java.io.IOException;

import org.eclipse.jdt.annotation.NonNull;

import de.carne.mcd.jvmdecoder.classfile.ClassContext;
import de.carne.mcd.jvmdecoder.classfile.ClassInfo;
import de.carne.mcd.jvmdecoder.classfile.ClassName;
import de.carne.mcd.jvmdecoder.classfile.ClassPrinter;

/**
 * Class constant.
 */
public class ClassConstant extends NameConstant {

	/**
	 * Class constant tag.
	 */
	public static final byte TAG = 7;

	/**
	 * Constructs a new {@linkplain ClassConstant} instance.
	 *
	 * @param classInfo the {@linkplain ClassInfo} instance this constant is part of.
	 * @param nameIndex the class constant name index.
	 */
	public ClassConstant(ClassInfo classInfo, int nameIndex) {
		super(classInfo, nameIndex);
	}

	@Override
	public @NonNull String resolveSymbol() throws IOException {
		return ClassName.effectiveName(ClassName.decode(getNameValue()), this.classInfo.thisClass().getPackageName());
	}

	@Override
	public void print(ClassPrinter out, ClassContext context) throws IOException {
		out.print(resolveSymbol());
	}

}
