/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.io;

import de.carne.mcd.MCDOutput;
import de.carne.mcd.PlainMCDOutput;
import de.carne.util.Exceptions;
import de.carne.util.Strings;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Deque;
import java.util.LinkedList;

public final class MCDPrintBuffer
implements MCDOutput {
    private final Deque<Entry> buffer = new LinkedList<Entry>();

    public boolean isEmtpy() {
        return this.buffer.isEmpty();
    }

    public void clear() {
        this.buffer.clear();
    }

    public void printTo(MCDOutput out) throws IOException {
        for (Entry entry : this.buffer) {
            entry.run(out);
        }
    }

    @Override
    public MCDPrintBuffer increaseIndent() throws IOException {
        this.buffer.add(MCDOutput::increaseIndent);
        return this;
    }

    @Override
    public MCDPrintBuffer decreaseIndent() throws IOException {
        this.buffer.add(MCDOutput::decreaseIndent);
        return this;
    }

    @Override
    public MCDPrintBuffer println() throws IOException {
        this.buffer.add(MCDOutput::println);
        return this;
    }

    @Override
    public MCDPrintBuffer print(String text) throws IOException {
        if (!Strings.isEmpty((String)text)) {
            this.buffer.add(out -> out.print(text));
        }
        return this;
    }

    @Override
    public MCDPrintBuffer println(String text) throws IOException {
        if (!Strings.isEmpty((String)text)) {
            this.buffer.add(out -> out.println(text));
        } else {
            this.buffer.add(MCDOutput::println);
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printValue(String value) throws IOException {
        if (!Strings.isEmpty((String)value)) {
            this.buffer.add(out -> out.printValue(value));
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printlnValue(String value) throws IOException {
        if (!Strings.isEmpty((String)value)) {
            this.buffer.add(out -> out.printlnValue(value));
        } else {
            this.buffer.add(MCDOutput::println);
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printComment(String comment) throws IOException {
        if (!Strings.isEmpty((String)comment)) {
            this.buffer.add(out -> out.printComment(comment));
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printlnComment(String comment) throws IOException {
        if (!Strings.isEmpty((String)comment)) {
            this.buffer.add(out -> out.printlnComment(comment));
        } else {
            this.buffer.add(MCDOutput::println);
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printKeyword(String keyword) throws IOException {
        if (!Strings.isEmpty((String)keyword)) {
            this.buffer.add(out -> out.printKeyword(keyword));
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printlnKeyword(String keyword) throws IOException {
        if (!Strings.isEmpty((String)keyword)) {
            this.buffer.add(out -> out.printlnKeyword(keyword));
        } else {
            this.buffer.add(MCDOutput::println);
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printOperator(String operator) throws IOException {
        if (!Strings.isEmpty((String)operator)) {
            this.buffer.add(out -> out.printOperator(operator));
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printlnOperator(String operator) throws IOException {
        if (!Strings.isEmpty((String)operator)) {
            this.buffer.add(out -> out.printlnOperator(operator));
        } else {
            this.buffer.add(MCDOutput::println);
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printLabel(String label) throws IOException {
        if (!Strings.isEmpty((String)label)) {
            this.buffer.add(out -> out.printLabel(label));
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printlnLabel(String label) throws IOException {
        if (!Strings.isEmpty((String)label)) {
            this.buffer.add(out -> out.printlnLabel(label));
        } else {
            this.buffer.add(MCDOutput::println);
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printError(String error) throws IOException {
        if (!Strings.isEmpty((String)error)) {
            this.buffer.add(out -> out.printError(error));
        }
        return this;
    }

    @Override
    public MCDPrintBuffer printlnError(String error) throws IOException {
        if (!Strings.isEmpty((String)error)) {
            this.buffer.add(out -> out.printlnError(error));
        } else {
            this.buffer.add(MCDOutput::println);
        }
        return this;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try (PlainMCDOutput out = new PlainMCDOutput(stringWriter, true);){
            this.printTo(out);
        }
        catch (IOException e) {
            Exceptions.toRuntime((Throwable)e);
        }
        return stringWriter.toString();
    }

    @FunctionalInterface
    private static interface Entry {
        public void run(MCDOutput var1) throws IOException;
    }
}

