/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.io;

import de.carne.io.Defaults;
import de.carne.mcd.io.MCDBuffer;
import de.carne.nio.file.FileUtil;
import de.carne.nio.file.attribute.FileAttributes;
import de.carne.util.Check;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MCDInputBuffer
implements MCDBuffer {
    private static final String MESSAGE_ILLEGAL_DISCARD_LENGTH = "Illegal discard length {0}";
    private static final String MESSAGE_UNEXPECTED_MAGIC_VALUE = "Unexpected magic value: ";
    private final ReadableByteChannel in;
    private ByteBuffer inputBuffer;
    private long totalRead = 0L;
    private int commitPosition = 0;
    private int uncommittedPosition = 0;
    private boolean autoCommit = true;
    private int sliceCount = 0;
    private @Nullable SeekableByteChannel sliceChannel = null;

    public MCDInputBuffer(ReadableByteChannel in, ByteOrder byteOrder) {
        this(in, byteOrder, Defaults.DEFAULT_BUFFER_SIZE);
    }

    public MCDInputBuffer(ReadableByteChannel in, ByteOrder byteOrder, int bufferSize) {
        this.in = in;
        this.inputBuffer = ByteBuffer.allocate(bufferSize).order(byteOrder);
    }

    public long getTotalRead() {
        return this.totalRead;
    }

    @Override
    public boolean setAutoCommit(boolean autoCommit) {
        boolean previousAutoCommit = this.autoCommit;
        this.autoCommit = autoCommit;
        return previousAutoCommit;
    }

    @Override
    public void commit() throws IOException {
        if (this.uncommittedPosition == this.inputBuffer.position()) {
            this.uncommittedPosition = 0;
            this.inputBuffer.clear();
        }
        this.commitPosition = this.uncommittedPosition;
    }

    @Override
    public void discard() {
        this.totalRead -= (long)(this.uncommittedPosition - this.commitPosition);
        this.uncommittedPosition = this.commitPosition;
    }

    public void discard(int length) {
        int uncomittedPositionAfterDiscard;
        if (length > 0) {
            uncomittedPositionAfterDiscard = this.commitPosition + length;
            Check.isTrue((uncomittedPositionAfterDiscard <= this.uncommittedPosition ? 1 : 0) != 0, (String)MESSAGE_ILLEGAL_DISCARD_LENGTH, (Object[])new Object[]{length});
            this.totalRead -= (long)(this.uncommittedPosition - uncomittedPositionAfterDiscard);
        } else {
            uncomittedPositionAfterDiscard = this.uncommittedPosition + length;
            Check.isTrue((this.commitPosition <= uncomittedPositionAfterDiscard ? 1 : 0) != 0, (String)MESSAGE_ILLEGAL_DISCARD_LENGTH, (Object[])new Object[]{length});
            this.totalRead += (long)length;
        }
        this.uncommittedPosition = uncomittedPositionAfterDiscard;
    }

    public SeekableByteChannel slice(long length) throws IOException {
        SlicedChannel slice;
        Check.isTrue((length >= 0L ? 1 : 0) != 0);
        Check.assertTrue((this.commitPosition == this.uncommittedPosition ? 1 : 0) != 0);
        if (this.in instanceof SeekableByteChannel) {
            SeekableByteChannel channel = (SeekableByteChannel)this.in;
            long position = channel.position();
            slice = new SlicedChannel(channel, position, length);
            channel.position(position + length);
        } else {
            SeekableByteChannel channel = this.allocateSliceChannel();
            long position = channel.size();
            channel.position(position);
            this.passThrough(length, channel::write);
            slice = new SlicedChannel(channel, position, length, this::releaseSliceChannel);
        }
        this.totalRead += length;
        return slice;
    }

    public void skip(long length) throws IOException {
        Check.isTrue((length >= 0L ? 1 : 0) != 0);
        Check.assertTrue((this.commitPosition == this.uncommittedPosition ? 1 : 0) != 0);
        if (this.in instanceof SeekableByteChannel) {
            SeekableByteChannel channel = (SeekableByteChannel)this.in;
            channel.position(channel.position() + length);
        } else {
            this.passThrough(length, b -> b.position(b.position() + b.remaining()));
        }
        this.totalRead += length;
    }

    public int read() throws IOException {
        this.feedInputBuffer(1, false);
        int value = -1;
        if (this.uncommittedPosition < this.inputBuffer.position()) {
            value = Byte.toUnsignedInt(this.inputBuffer.get(this.uncommittedPosition));
            ++this.uncommittedPosition;
            ++this.totalRead;
            if (this.autoCommit) {
                this.commit();
            }
        }
        return value;
    }

    public byte decodeI8() throws IOException {
        this.feedInputBuffer(1, true);
        byte decoded = this.inputBuffer.get(this.uncommittedPosition);
        ++this.uncommittedPosition;
        ++this.totalRead;
        if (this.autoCommit) {
            this.commit();
        }
        return decoded;
    }

    public ByteBuffer decodeI8Array(int arrayLength) throws IOException {
        Check.isTrue((arrayLength >= 0 ? 1 : 0) != 0);
        int length = arrayLength * 1;
        this.feedInputBuffer(length, true);
        ByteBuffer decoded = this.inputBuffer.asReadOnlyBuffer();
        int uncommittedPositionAfterDecode = this.uncommittedPosition + length;
        decoded.position(this.uncommittedPosition).limit(uncommittedPositionAfterDecode);
        this.uncommittedPosition = uncommittedPositionAfterDecode;
        this.totalRead += (long)length;
        if (this.autoCommit) {
            this.commit();
        }
        return decoded;
    }

    public static byte[] toI8Array(ByteBuffer buffer) {
        int length = buffer.remaining();
        byte[] array = new byte[length];
        buffer.get(array);
        return array;
    }

    public void decodeMagic(byte expectedMagic) throws IOException {
        byte actualMagic = this.decodeI8();
        if (expectedMagic != actualMagic) {
            throw new IOException(MESSAGE_UNEXPECTED_MAGIC_VALUE + actualMagic);
        }
    }

    public short decodeI16() throws IOException {
        this.feedInputBuffer(2, true);
        short decoded = this.inputBuffer.getShort(this.uncommittedPosition);
        this.uncommittedPosition += 2;
        this.totalRead += 2L;
        if (this.autoCommit) {
            this.commit();
        }
        return decoded;
    }

    public ByteBuffer decodeI16Array(int arrayLength) throws IOException {
        Check.isTrue((arrayLength >= 0 ? 1 : 0) != 0);
        int length = arrayLength * 2;
        this.feedInputBuffer(length, true);
        ByteBuffer decoded = this.inputBuffer.asReadOnlyBuffer();
        int uncommittedPositionAfterDecode = this.uncommittedPosition + length;
        decoded.position(this.uncommittedPosition).limit(uncommittedPositionAfterDecode);
        this.uncommittedPosition = uncommittedPositionAfterDecode;
        this.totalRead += (long)length;
        if (this.autoCommit) {
            this.commit();
        }
        return decoded;
    }

    public static short[] toI16Array(ByteBuffer buffer) {
        int length = buffer.remaining() / 2;
        short[] array = new short[length];
        for (int index = 0; index < length; ++index) {
            array[index] = buffer.getShort();
        }
        return array;
    }

    public void decodeMagic(short expectedMagic) throws IOException {
        short actualMagic = this.decodeI16();
        if (expectedMagic != actualMagic) {
            throw new IOException(MESSAGE_UNEXPECTED_MAGIC_VALUE + actualMagic);
        }
    }

    public int decodeI32() throws IOException {
        this.feedInputBuffer(4, true);
        int decoded = this.inputBuffer.getInt(this.uncommittedPosition);
        this.uncommittedPosition += 4;
        this.totalRead += 4L;
        if (this.autoCommit) {
            this.commit();
        }
        return decoded;
    }

    public ByteBuffer decodeI32Array(int arrayLength) throws IOException {
        Check.isTrue((arrayLength >= 0 ? 1 : 0) != 0);
        int length = arrayLength * 4;
        this.feedInputBuffer(length, true);
        ByteBuffer decoded = this.inputBuffer.asReadOnlyBuffer();
        int uncommittedPositionAfterDecode = this.uncommittedPosition + length;
        decoded.position(this.uncommittedPosition).limit(uncommittedPositionAfterDecode);
        this.uncommittedPosition = uncommittedPositionAfterDecode;
        this.totalRead += (long)length;
        if (this.autoCommit) {
            this.commit();
        }
        return decoded;
    }

    public static int[] toI32Array(ByteBuffer buffer) {
        int length = buffer.remaining() / 4;
        int[] array = new int[length];
        for (int index = 0; index < length; ++index) {
            array[index] = buffer.getInt();
        }
        return array;
    }

    public void decodeMagic(int expectedMagic) throws IOException {
        int actualMagic = this.decodeI32();
        if (expectedMagic != actualMagic) {
            throw new IOException(MESSAGE_UNEXPECTED_MAGIC_VALUE + actualMagic);
        }
    }

    public long decodeI64() throws IOException {
        this.feedInputBuffer(8, true);
        long decoded = this.inputBuffer.getLong(this.uncommittedPosition);
        this.uncommittedPosition += 8;
        this.totalRead += 8L;
        if (this.autoCommit) {
            this.commit();
        }
        return decoded;
    }

    public ByteBuffer decodeI64Array(int arrayLength) throws IOException {
        Check.isTrue((arrayLength >= 0 ? 1 : 0) != 0);
        int length = arrayLength * 8;
        this.feedInputBuffer(length, true);
        ByteBuffer decoded = this.inputBuffer.asReadOnlyBuffer();
        int uncommittedPositionAfterDecode = this.uncommittedPosition + length;
        decoded.position(this.uncommittedPosition).limit(uncommittedPositionAfterDecode);
        this.uncommittedPosition = uncommittedPositionAfterDecode;
        this.totalRead += (long)length;
        if (this.autoCommit) {
            this.commit();
        }
        return decoded;
    }

    public static long[] toI64Array(ByteBuffer buffer) {
        int length = buffer.remaining() / 8;
        long[] array = new long[length];
        for (int index = 0; index < length; ++index) {
            array[index] = buffer.getLong();
        }
        return array;
    }

    public void decodeMagic(long expectedMagic) throws IOException {
        long actualMagic = this.decodeI64();
        if (expectedMagic != actualMagic) {
            throw new IOException(MESSAGE_UNEXPECTED_MAGIC_VALUE + actualMagic);
        }
    }

    public float decodeF32() throws IOException {
        this.feedInputBuffer(4, true);
        float decoded = this.inputBuffer.getFloat(this.uncommittedPosition);
        this.uncommittedPosition += 4;
        this.totalRead += 4L;
        if (this.autoCommit) {
            this.commit();
        }
        return decoded;
    }

    public double decodeF64() throws IOException {
        this.feedInputBuffer(8, true);
        double decoded = this.inputBuffer.getDouble(this.uncommittedPosition);
        this.uncommittedPosition += 8;
        this.totalRead += 8L;
        if (this.autoCommit) {
            this.commit();
        }
        return decoded;
    }

    private void feedInputBuffer(int length, boolean fully) throws IOException {
        int inputBufferPosition = this.inputBuffer.position();
        int available = inputBufferPosition - this.uncommittedPosition;
        if (available < length) {
            int unavailable = length - available;
            if (this.inputBuffer.remaining() < unavailable) {
                if (inputBufferPosition == 0) {
                    this.inputBuffer = ByteBuffer.allocate(length).order(this.inputBuffer.order());
                } else {
                    throw new IOException("Insufficient input buffer capacity: " + this.uncommittedPosition + "/" + available + "/" + unavailable);
                }
            }
            ByteBuffer buffer = this.inputBuffer.duplicate();
            buffer.limit(inputBufferPosition + unavailable);
            int read = fully ? this.readFully(buffer) : this.readAny(buffer);
            this.inputBuffer.position(inputBufferPosition + read);
        }
    }

    private int readFully(ByteBuffer buffer) throws IOException {
        int read = 0;
        while (buffer.hasRemaining()) {
            int read0 = this.in.read(buffer);
            if (read0 < 0) {
                throw new EOFException();
            }
            read += read0;
        }
        return read;
    }

    private int readAny(ByteBuffer buffer) throws IOException {
        int read0;
        int read = 0;
        while (buffer.hasRemaining() && (read0 = this.in.read(buffer)) >= 0) {
            read += read0;
        }
        return read;
    }

    private void passThrough(long length, PassThroughHandler handler) throws IOException {
        int readLimit;
        ByteBuffer readBuffer = ByteBuffer.allocate(Defaults.DEFAULT_BUFFER_SIZE);
        for (long remaining = length; remaining > 0L; remaining -= (long)readLimit) {
            readLimit = (int)Math.min(remaining, (long)readBuffer.capacity());
            readBuffer.clear().limit(readLimit);
            int read = this.in.read(readBuffer);
            if (read < 0) {
                throw new EOFException();
            }
            readBuffer.flip();
            while (readBuffer.hasRemaining()) {
                handler.accept(readBuffer);
            }
        }
    }

    public @NonNull String toString() {
        return "commit: " + this.commitPosition + "; uncommitted: " + this.uncommittedPosition + "; total: " + this.totalRead;
    }

    private SeekableByteChannel allocateSliceChannel() throws IOException {
        SeekableByteChannel channel;
        if (this.sliceCount == 0) {
            Path tempDir = FileUtil.tmpDir();
            Path channelPath = Files.createTempFile(tempDir, null, null, FileAttributes.userFileDefault((Path)tempDir));
            channel = this.sliceChannel = Files.newByteChannel(channelPath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE);
        } else {
            channel = this.sliceChannel;
        }
        ++this.sliceCount;
        return channel;
    }

    private void releaseSliceChannel() throws IOException {
        ++this.sliceCount;
        if (this.sliceCount == 0) {
            this.sliceChannel.close();
            this.sliceChannel = null;
        }
    }

    private class SlicedChannel
    implements SeekableByteChannel {
        private final SeekableByteChannel channel;
        private final long start;
        private final long length;
        private final CloseSliceChannelHandler closeHandler;
        private long position = 0L;

        SlicedChannel(SeekableByteChannel channel, long start, long length) {
            this(channel, start, length, () -> {});
        }

        SlicedChannel(SeekableByteChannel channel, long start, long length, CloseSliceChannelHandler closeHandler) {
            this.channel = channel;
            this.start = start;
            this.length = length;
            this.closeHandler = closeHandler;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.closeHandler.close();
        }

        @Override
        public int read(@Nullable ByteBuffer dst) throws IOException {
            Objects.requireNonNull(dst);
            int readLimit = (int)Math.min(this.length - this.position, (long)dst.remaining());
            int read = -1;
            if (readLimit > 0) {
                ByteBuffer limitedDst = dst.duplicate();
                limitedDst.limit(limitedDst.position() + readLimit);
                this.channel.position(this.start + this.position);
                read = this.channel.read(limitedDst);
                if (read > 0) {
                    dst.position(dst.position() + read);
                    this.position += (long)read;
                }
            }
            return read;
        }

        @Override
        public int write(@Nullable ByteBuffer src) throws IOException {
            throw new NonWritableChannelException();
        }

        @Override
        public long position() throws IOException {
            return this.position;
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            Check.isTrue((newPosition >= 0L ? 1 : 0) != 0);
            if (newPosition > this.length) {
                throw new NonWritableChannelException();
            }
            this.position = newPosition;
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.length;
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            throw new NonWritableChannelException();
        }
    }

    @FunctionalInterface
    private static interface CloseSliceChannelHandler {
        public void close() throws IOException;
    }

    @FunctionalInterface
    private static interface PassThroughHandler {
        public void accept(ByteBuffer var1) throws IOException;
    }
}

