/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.instruction;

import de.carne.text.HexFormat;
import de.carne.util.Check;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.Nullable;

public class InstructionOpcode
implements Comparable<InstructionOpcode> {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    public static final InstructionOpcode EMPTY = new InstructionOpcode(new byte[0], 0, 0);

    private InstructionOpcode(byte[] bytes, int offset, int length) {
        Check.isTrue((length < 256 ? 1 : 0) != 0);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public static InstructionOpcode wrap(byte[] bytes) {
        return InstructionOpcode.wrap(bytes, 0, bytes.length);
    }

    public static InstructionOpcode wrap(byte[] bytes, int offset, int length) {
        return new InstructionOpcode(bytes, offset, length);
    }

    public static InstructionOpcode decode(byte[] encoded) {
        return InstructionOpcode.wrap(encoded, 1, Byte.toUnsignedInt(encoded[0]));
    }

    public int length() {
        return this.length;
    }

    public byte byteAt(int n) {
        return this.bytes[this.offset + n];
    }

    public byte[] bytes() {
        byte[] opcodesBytes = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, opcodesBytes, 0, this.length);
        return opcodesBytes;
    }

    public byte[] encode(int encodedBytes) {
        Check.isTrue((this.length < encodedBytes ? 1 : 0) != 0);
        byte[] encoded = new byte[encodedBytes];
        encoded[0] = (byte)this.length;
        System.arraycopy(this.bytes, 0, encoded, 1, this.length);
        return encoded;
    }

    @Override
    public int compareTo(InstructionOpcode o) {
        return InstructionOpcode.compareTo(this.bytes, this.offset, this.length, o.bytes, o.offset, o.length);
    }

    public static int compareTo(byte[] bytes1, int offset1, int length1, byte[] bytes2, int offset2, int length2) {
        int comparison = Integer.compare(length1, length2);
        if (comparison == 0) {
            int byte2;
            int byte1;
            for (int compareIndex = 0; compareIndex < length1 && (comparison = Integer.compare(byte1 = Byte.toUnsignedInt(bytes1[offset1 + compareIndex]), byte2 = Byte.toUnsignedInt(bytes2[offset2 + compareIndex]))) == 0; ++compareIndex) {
            }
        }
        return comparison;
    }

    public int hashCode() {
        int hashCode = this.length;
        for (int byteIndex = this.offset + Math.min(this.length - 1, 3); byteIndex >= this.offset; --byteIndex) {
            hashCode |= Byte.toUnsignedInt(this.bytes[byteIndex]);
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof InstructionOpcode && this.compareTo((InstructionOpcode)obj) == 0;
    }

    public String toString() {
        return InstructionOpcode.toString(this.bytes, this.offset, this.length);
    }

    public static String toString(byte[] bytes) {
        return InstructionOpcode.toString(bytes, 0, bytes.length);
    }

    public static String toString(byte[] bytes, int offset, int length) {
        return HexFormat.UPPER_CASE.format(bytes, offset, length);
    }

    public static byte[] parse(String s) {
        StringTokenizer byteStrings = new StringTokenizer(s, " ");
        ArrayList<Byte> bytesList = new ArrayList<Byte>();
        while (byteStrings.hasMoreElements()) {
            String byteString = byteStrings.nextToken();
            int byteValue = Integer.parseUnsignedInt(byteString, 16);
            if (byteValue > 255) {
                throw new NumberFormatException("Invalid byte value: " + byteString);
            }
            bytesList.add((byte)(byteValue & 0xFF));
        }
        byte[] bytesArray = new byte[bytesList.size()];
        int byteIndex = 0;
        for (Byte byteValue : bytesList) {
            bytesArray[byteIndex] = byteValue;
            ++byteIndex;
        }
        return bytesArray;
    }
}

