/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.instruction;

public interface InstructionIndexParameters {
    default public int parameters() {
        int entryCount = this.entryCount();
        if (entryCount < 0 || 0xFFFFFF < entryCount) {
            throw new IllegalStateException("Invalid entry count: " + entryCount);
        }
        int opcodeBytes = this.opcodeBytes();
        if (opcodeBytes < 1 || 15 < opcodeBytes) {
            throw new IllegalStateException("Invalid opcode bytes count: " + opcodeBytes);
        }
        int positionBytes = this.positionBytes();
        if (positionBytes < 1 || 15 < positionBytes) {
            throw new IllegalStateException("Invalid position bytes count: " + positionBytes);
        }
        return (entryCount & 0xFFFFFF) << 8 | (opcodeBytes - 1 & 0xF) << 4 | positionBytes - 1 & 0xF;
    }

    public int entryCount();

    public int opcodeBytes();

    public int positionBytes();
}

