/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.instruction;

import de.carne.io.IOUtil;
import de.carne.mcd.instruction.Instruction;
import de.carne.mcd.instruction.InstructionFactory;
import de.carne.mcd.instruction.InstructionIndexParameters;
import de.carne.mcd.instruction.InstructionOpcode;
import de.carne.mcd.io.MCDInputBuffer;
import de.carne.mcd.io.MCDOutputBuffer;
import de.carne.util.logging.Log;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class InstructionIndex
implements InstructionIndexParameters,
Closeable {
    private static final Log LOG = new Log();
    private final InstructionFactory instructionFactory;
    private final int entryCount;
    private final int entryBytes;
    private final int opcodeBytes;
    private final byte[] lookupTable;
    private final FileChannel dataFile;
    private final Map<Integer, SoftReference<Instruction>> instructionCache = new HashMap<Integer, SoftReference<Instruction>>();

    private InstructionIndex(InstructionFactory instructionFactory, int entryCount, int entryBytes, int opcodeBytes, byte[] lookupTable, FileChannel dataFile) {
        this.instructionFactory = instructionFactory;
        this.entryCount = entryCount;
        this.entryBytes = entryBytes;
        this.opcodeBytes = opcodeBytes;
        this.lookupTable = lookupTable;
        this.dataFile = dataFile;
    }

    public static InstructionIndex open(InstructionFactory instructionFactory, URL url) throws IOException {
        InstructionIndex index;
        LOG.info("Opening index: ''{0}''...", new Object[]{url});
        try (DataInputStream indexStream = new DataInputStream(url.openStream());){
            int parameters = indexStream.readInt();
            int entryCount = parameters >> 8 & 0xFFFFFF;
            int opcodeBytes = 1 + (parameters >> 4) & 0xF;
            int positionBytes = 1 + (parameters & 0xF);
            LOG.debug(" Index parameters: {0}/{1}/{2}", new Object[]{entryCount, opcodeBytes, positionBytes});
            int entryBytes = opcodeBytes + positionBytes;
            byte[] lookupTable = new byte[entryCount * entryBytes];
            indexStream.readFully(lookupTable);
            Path dataFilePath = Files.createTempFile(InstructionIndex.class.getSimpleName(), null, new FileAttribute[0]);
            LOG.debug(" Data file: ''{0}''", new Object[]{dataFilePath});
            IOUtil.copyStream((File)dataFilePath.toFile(), (InputStream)indexStream);
            index = new InstructionIndex(instructionFactory, entryCount, entryBytes, opcodeBytes, lookupTable, FileChannel.open(dataFilePath, StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE));
        }
        return index;
    }

    public @Nullable LookupResult lookupNextInstruction(MCDInputBuffer buffer, boolean eager) throws IOException {
        LookupResult lookupResult = null;
        int opcodeByte = buffer.read();
        if (opcodeByte >= 0) {
            byte[] opcode = new byte[this.opcodeBytes];
            int opcodeLength = 0;
            int previousMatch = -1;
            do {
                int match = -1;
                if (opcodeByte >= 0) {
                    opcode[opcodeLength] = (byte)opcodeByte;
                    match = this.matchOpcode(opcode, 0, ++opcodeLength);
                }
                if (match >= 0) {
                    if (!eager) {
                        lookupResult = new LookupResult(opcode, 0, opcodeLength, this.loadInstruction(match));
                        continue;
                    }
                    previousMatch = match;
                    opcodeByte = buffer.read();
                    continue;
                }
                if (previousMatch >= 0) {
                    if (opcodeByte >= 0) {
                        int previousOpcodeLength = opcodeLength - 1;
                        lookupResult = new LookupResult(opcode, 0, previousOpcodeLength, this.loadInstruction(previousMatch));
                        buffer.discard(-1);
                        continue;
                    }
                    lookupResult = new LookupResult(opcode, 0, opcodeLength, this.loadInstruction(previousMatch));
                    continue;
                }
                if (opcodeByte >= 0 && opcodeLength < this.opcodeBytes - 1) {
                    opcodeByte = buffer.read();
                    continue;
                }
                lookupResult = new LookupResult(opcode, 0, 1, this.instructionFactory.getDefaultInstruction());
                buffer.discard(-opcodeLength + 1);
            } while (lookupResult == null);
        }
        return lookupResult;
    }

    private int matchOpcode(byte[] bytes, int offset, int length) {
        int matchStart = 0;
        int matchEnd = this.entryCount;
        int match = -1;
        while (matchStart < matchEnd && match < 0) {
            int matchNext = matchStart + (matchEnd - matchStart) / 2;
            int lookupTableOffset = matchNext * this.entryBytes;
            int comparision = InstructionOpcode.compareTo(bytes, offset, length, this.lookupTable, lookupTableOffset + 1, this.lookupTable[lookupTableOffset] & 0xFF);
            if (comparision < 0) {
                matchEnd = matchNext;
                continue;
            }
            if (comparision > 0) {
                matchStart = matchNext + 1;
                continue;
            }
            match = matchNext;
        }
        return match;
    }

    private synchronized Instruction loadInstruction(int lookupTableIndex) throws IOException {
        Instruction instruction;
        Integer dataCacheKey = lookupTableIndex;
        SoftReference<Instruction> instructionReference = this.instructionCache.get(dataCacheKey);
        Instruction instruction2 = instruction = instructionReference != null ? instructionReference.get() : null;
        if (instruction == null) {
            int positionBytes = this.positionBytes();
            long dataPosition = this.getDecodedPosition(this.lookupTable, lookupTableIndex * this.entryBytes + this.opcodeBytes, positionBytes);
            this.dataFile.position(dataPosition);
            instruction = this.instructionFactory.loadInstruction(new DataInputStream(Channels.newInputStream(this.dataFile)));
            this.instructionCache.put(dataCacheKey, new SoftReference<Instruction>(instruction));
        }
        return instruction;
    }

    private long getDecodedPosition(byte[] bytes, int offset, int length) {
        long decoded = 0L;
        for (int decodeIndex = length - 1; decodeIndex >= 0; --decodeIndex) {
            decoded = decoded << 8 | (long)Byte.toUnsignedInt(bytes[offset + decodeIndex]);
        }
        return decoded;
    }

    @Override
    public int entryCount() {
        return this.entryCount;
    }

    @Override
    public int opcodeBytes() {
        return this.opcodeBytes;
    }

    @Override
    public int positionBytes() {
        return this.entryBytes - this.opcodeBytes;
    }

    @Override
    public void close() throws IOException {
        this.dataFile.close();
    }

    public static final class LookupResult {
        private final InstructionOpcode opcode;
        private final Instruction instruction;

        LookupResult(byte[] opcodeBytes, int offset, int length, Instruction instruction) {
            this.opcode = InstructionOpcode.wrap(opcodeBytes, offset, length);
            this.instruction = instruction;
        }

        public InstructionOpcode opcode() {
            return this.opcode;
        }

        public Instruction instruction() {
            return this.instruction;
        }

        public void decode(long ip, MCDInputBuffer in, MCDOutputBuffer out) throws IOException {
            this.instruction.decode(ip, this.opcode, in, out);
        }

        public String toString() {
            return this.opcode + " " + this.instruction;
        }
    }
}

