/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.bootstrap;

import de.carne.mcd.instruction.Instruction;
import de.carne.mcd.instruction.InstructionOpcode;
import de.carne.util.Check;
import de.carne.util.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public class InstructionReferenceEntry {
    public static final String NO_VALUE = "-";
    private final InstructionOpcode opcode;
    private final String mnemonic;
    private final List<String> extraFields;

    protected InstructionReferenceEntry(InstructionOpcode opcode, String mnemonic, List<String> extraFields) {
        this.opcode = opcode;
        this.mnemonic = mnemonic;
        ArrayList<String> normalizedExtraFields = new ArrayList<String>(extraFields.size());
        for (String extraField : extraFields) {
            normalizedExtraFields.add(Strings.isEmpty((String)extraField) ? NO_VALUE : extraField);
        }
        this.extraFields = normalizedExtraFields;
    }

    protected InstructionReferenceEntry(InstructionReferenceEntry entryData) {
        this(entryData.opcode, entryData.mnemonic, entryData.extraFields);
    }

    public InstructionOpcode opcode() {
        return this.opcode;
    }

    public String mnemonic() {
        return this.mnemonic;
    }

    public List<String> extraFields() {
        return Collections.unmodifiableList(this.extraFields);
    }

    public String getExtraField(int index) {
        return this.extraFields.get(index);
    }

    public void setExtraField(int index, String value) {
        this.extraFields.set(index, value);
    }

    public void addExtraFields(List<String> additionalExtraFields) {
        this.extraFields.addAll(additionalExtraFields);
    }

    public Instruction toInstruction() throws IOException {
        throw Check.fail();
    }

    public int hashCode() {
        return Objects.hash(this.opcode, this.mnemonic);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof InstructionReferenceEntry && this.deepEquals((InstructionReferenceEntry)obj);
    }

    private boolean deepEquals(InstructionReferenceEntry obj) {
        return this.opcode.equals(obj.opcode) && this.mnemonic.equals(obj.mnemonic) && this.extraFields.equals(obj.extraFields);
    }

    public String toString() {
        return this.opcode + " " + this.mnemonic;
    }
}

