/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.bootstrap;

import de.carne.mcd.bootstrap.InstructionIndexBuilder;
import de.carne.mcd.bootstrap.InstructionReferenceEntry;
import de.carne.mcd.instruction.InstructionOpcode;
import de.carne.util.Strings;
import de.carne.util.logging.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;

public abstract class InstructionReference<T extends InstructionReferenceEntry> {
    private static final Log LOG = new Log();
    private static final String FIELD_SEPARATOR = ";";
    private final Map<InstructionOpcode, T> referenceMap = new TreeMap<InstructionOpcode, T>();
    private final Set<InstructionOpcode> untouchedEntries = new HashSet<InstructionOpcode>();
    private final Set<InstructionOpcode> uptodateEntries = new HashSet<InstructionOpcode>();
    private final Set<InstructionOpcode> updatedEntries = new HashSet<InstructionOpcode>();
    private final Set<InstructionOpcode> addedEntries = new HashSet<InstructionOpcode>();

    public void load(File file) throws IOException {
        this.load(file, StandardCharsets.UTF_8);
    }

    public void load(File file, Charset cs) throws IOException {
        LOG.info("Loading instruction reference from file ''{0}''...", new Object[]{file});
        this.referenceMap.clear();
        this.untouchedEntries.clear();
        this.uptodateEntries.clear();
        this.updatedEntries.clear();
        this.addedEntries.clear();
        try (BufferedReader lineReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), cs));){
            String line;
            while ((line = lineReader.readLine()) != null) {
                T entry = this.newEntry(this.decodeEntryData(line));
                this.referenceMap.put(((InstructionReferenceEntry)entry).opcode(), entry);
            }
        }
        this.untouchedEntries.addAll(this.referenceMap.keySet());
        LOG.info("Loaded {0} reference entries", new Object[]{this.referenceMap.size()});
    }

    private InstructionReferenceEntry decodeEntryData(String line) throws IOException {
        String mnemonic;
        InstructionOpcode opcode;
        StringTokenizer tokens = new StringTokenizer(line, FIELD_SEPARATOR);
        ArrayList<String> extraFields = new ArrayList<String>();
        try {
            opcode = InstructionOpcode.wrap(InstructionOpcode.parse(tokens.nextToken().trim()));
            mnemonic = tokens.nextToken().trim();
        }
        catch (Exception e) {
            throw new IOException("Failed to decode reference line: \"" + Strings.encode((CharSequence)line) + "\"", e);
        }
        while (tokens.hasMoreElements()) {
            extraFields.add(tokens.nextToken().trim());
        }
        return new InstructionReferenceEntry(opcode, mnemonic, extraFields);
    }

    private T newEntry(InstructionOpcode opcode, String mnemonic, List<String> extraFields) throws IOException {
        return this.newEntry(new InstructionReferenceEntry(opcode, mnemonic, extraFields));
    }

    protected abstract T newEntry(InstructionReferenceEntry var1) throws IOException;

    public void addOrUpdateEntries(Iterable<T> entries) throws IOException {
        for (InstructionReferenceEntry entry : entries) {
            this.addOrUpdateEntry(entry);
        }
    }

    public void addOrUpdateEntry(T entry) throws IOException {
        Object newEntry;
        @Nullable InstructionReferenceEntry oldEntry = (InstructionReferenceEntry)this.referenceMap.get(((InstructionReferenceEntry)entry).opcode());
        if (oldEntry != null) {
            newEntry = this.mergeEntries(oldEntry, entry);
            this.untouchedEntries.remove(oldEntry.opcode());
            if (((InstructionReferenceEntry)newEntry).equals(oldEntry)) {
                this.uptodateEntries.add(((InstructionReferenceEntry)newEntry).opcode());
            } else {
                this.updatedEntries.add(((InstructionReferenceEntry)newEntry).opcode());
            }
        } else {
            newEntry = entry;
            this.addedEntries.add(((InstructionReferenceEntry)newEntry).opcode());
        }
        this.referenceMap.put(((InstructionReferenceEntry)newEntry).opcode(), newEntry);
    }

    protected T mergeEntries(T left, T right) throws IOException {
        ArrayList<String> mergedExtraFields;
        List<String> leftExtraFields = ((InstructionReferenceEntry)left).extraFields();
        List<String> rightExtraFields = ((InstructionReferenceEntry)right).extraFields();
        if (leftExtraFields.size() > rightExtraFields.size()) {
            mergedExtraFields = new ArrayList<String>(leftExtraFields);
            int extraFieldIndex = 0;
            for (String rightExtraField : ((InstructionReferenceEntry)right).extraFields()) {
                mergedExtraFields.set(extraFieldIndex, rightExtraField);
                ++extraFieldIndex;
            }
        } else {
            mergedExtraFields = new ArrayList<String>(rightExtraFields);
        }
        return this.newEntry(((InstructionReferenceEntry)left).opcode(), ((InstructionReferenceEntry)right).mnemonic(), mergedExtraFields);
    }

    public void save(File file) throws IOException {
        this.save(file, StandardCharsets.UTF_8);
    }

    public void save(File file, Charset cs) throws IOException {
        LOG.info("Saving instruction reference to file ''{0}''...", new Object[]{file});
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE), cs));){
            StringBuilder lineBuffer = new StringBuilder();
            for (InstructionReferenceEntry entry : this.referenceMap.values()) {
                lineBuffer.setLength(0);
                lineBuffer.append(entry.opcode().toString()).append(FIELD_SEPARATOR);
                lineBuffer.append(entry.mnemonic());
                for (String extraField : entry.extraFields()) {
                    lineBuffer.append(FIELD_SEPARATOR).append(extraField);
                }
                writer.write(lineBuffer.toString());
                writer.newLine();
            }
        }
        LOG.info("Saved {0} reference entries", new Object[]{this.referenceMap.size()});
    }

    public InstructionIndexBuilder build(InstructionIndexBuilder builder) throws IOException {
        for (InstructionReferenceEntry entry : this.referenceMap.values()) {
            builder.add(entry.opcode(), entry.toInstruction());
        }
        return builder;
    }

    public void logStatus() {
        LOG.notice("Total reference entries: {0}", new Object[]{this.referenceMap.size()});
        LOG.notice("             up-to-date: {0}", new Object[]{this.uptodateEntries.size()});
        LOG.notice("              untouched: {0} {1}", new Object[]{this.untouchedEntries.size(), this.untouchedEntries});
        LOG.notice("                updated: {0} {1}", new Object[]{this.updatedEntries.size(), this.updatedEntries});
        LOG.notice("                  added: {0} {1}", new Object[]{this.addedEntries.size(), this.addedEntries});
    }
}

