/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.bootstrap;

import de.carne.mcd.instruction.Instruction;
import de.carne.mcd.instruction.InstructionIndexParameters;
import de.carne.mcd.instruction.InstructionOpcode;
import de.carne.util.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class InstructionIndexBuilder
implements InstructionIndexParameters {
    private static final Log LOG = new Log();
    private final SortedMap<InstructionOpcode, InstructionEntry> instructionTable = new TreeMap<InstructionOpcode, InstructionEntry>();
    private int maxOpcodeLength = 0;
    private long totalInstructionSize = 0L;

    public void add(InstructionOpcode opcode, Instruction instruction) throws IOException {
        int instructionSize;
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();
             DataOutputStream out = new DataOutputStream(bytes);){
            instruction.save(out);
            out.flush();
            instructionSize = bytes.size();
        }
        this.instructionTable.put(opcode, new InstructionEntry(instruction, instructionSize));
        this.maxOpcodeLength = Math.max(this.maxOpcodeLength, opcode.length());
        this.totalInstructionSize += (long)instructionSize;
    }

    public long save(File file) throws IOException {
        long totalIndexSize = 0L;
        LOG.info("Saving instruction index to file ''{0}''...", new Object[]{file});
        try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE));){
            out.writeInt(this.parameters());
            totalIndexSize += 4L;
            int entryCount = this.instructionTable.size();
            int opcodeBytes = this.opcodeBytes();
            int positionBytes = this.positionBytes();
            LOG.debug(" Index parameters: {0}/{1}/{2}", new Object[]{entryCount, opcodeBytes, positionBytes});
            long nextInstructionPosition = 0L;
            for (Map.Entry<InstructionOpcode, InstructionEntry> entry : this.instructionTable.entrySet()) {
                InstructionOpcode opcode = entry.getKey();
                LOG.trace(" {0} -> position:{1}", new Object[]{opcode, nextInstructionPosition});
                InstructionEntry instructionEntry = entry.getValue();
                out.write(opcode.encode(opcodeBytes));
                totalIndexSize += (long)opcodeBytes;
                out.write(this.getEncodedPosition(nextInstructionPosition, positionBytes));
                totalIndexSize += (long)positionBytes;
                nextInstructionPosition += (long)instructionEntry.instructionSize();
            }
            for (InstructionEntry instructionEntry : this.instructionTable.values()) {
                instructionEntry.instruction().save(out);
                totalIndexSize += (long)instructionEntry.instructionSize();
            }
        }
        return totalIndexSize;
    }

    private byte[] getEncodedPosition(long position, int positionBytes) {
        byte[] encoded = new byte[positionBytes];
        long shift = position;
        for (int encodeIndex = 0; encodeIndex < positionBytes; ++encodeIndex) {
            encoded[encodeIndex] = (byte)(shift & 0xFFL);
            shift >>= 8;
        }
        return encoded;
    }

    @Override
    public int entryCount() {
        return this.instructionTable.size();
    }

    @Override
    public int opcodeBytes() {
        return 1 + this.maxOpcodeLength + 1 & 0xFFFFFFFE;
    }

    @Override
    public int positionBytes() {
        int positionBytes = this.totalInstructionSize <= 65536L ? 2 : (this.totalInstructionSize <= 0x100000000L ? 4 : 8);
        return positionBytes;
    }

    private static class InstructionEntry {
        private final Instruction instruction;
        private final int instructionSize;

        InstructionEntry(Instruction instruction, int instructionSize) {
            this.instruction = instruction;
            this.instructionSize = instructionSize;
        }

        public Instruction instruction() {
            return this.instruction;
        }

        public int instructionSize() {
            return this.instructionSize;
        }
    }
}

