/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd;

import de.carne.mcd.MCDOutput;
import de.carne.util.Check;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import org.eclipse.jdt.annotation.NonNull;

public class PlainMCDOutput
implements MCDOutput,
Closeable,
Flushable {
    private static final String INDENT = "    ";
    private final PrintWriter pw;
    private final boolean autoClose;
    private boolean closed = false;
    private int indentLevel = 0;
    private boolean newLine = true;

    public PlainMCDOutput(Writer out, boolean autoClose) {
        this.pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        this.autoClose = autoClose;
    }

    public PlainMCDOutput(PrintStream ps, boolean autoClose) {
        this(new PrintWriter(ps), autoClose);
    }

    public PlainMCDOutput(WritableByteChannel channel, boolean autoClose) {
        this(new PrintWriter(Channels.newOutputStream(channel)), autoClose);
    }

    @Override
    public void flush() throws IOException {
        this.pw.flush();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.autoClose) {
            this.pw.close();
        } else {
            this.pw.flush();
        }
    }

    @Override
    public @NonNull MCDOutput increaseIndent() throws IOException {
        ++this.indentLevel;
        return this;
    }

    @Override
    public @NonNull MCDOutput decreaseIndent() throws IOException {
        Check.isTrue((this.indentLevel > 0 ? 1 : 0) != 0);
        --this.indentLevel;
        return this;
    }

    @Override
    public MCDOutput println() throws IOException {
        this.ensureNotClosed();
        this.printIndentIfNeeded();
        this.pw.println();
        this.newLine = true;
        return this;
    }

    @Override
    public MCDOutput print(String text) throws IOException {
        this.ensureNotClosed();
        this.printIndentIfNeeded();
        this.pw.print(text);
        return this;
    }

    @Override
    public MCDOutput println(String text) throws IOException {
        this.ensureNotClosed();
        this.printIndentIfNeeded();
        this.pw.println(text);
        this.newLine = true;
        return this;
    }

    @Override
    public MCDOutput printValue(String value) throws IOException {
        return this.print(value);
    }

    @Override
    public MCDOutput printlnValue(String value) throws IOException {
        return this.println(value);
    }

    @Override
    public MCDOutput printComment(String comment) throws IOException {
        return this.print(comment);
    }

    @Override
    public MCDOutput printlnComment(String comment) throws IOException {
        return this.println(comment);
    }

    @Override
    public MCDOutput printKeyword(String keyword) throws IOException {
        return this.print(keyword);
    }

    @Override
    public MCDOutput printlnKeyword(String keyword) throws IOException {
        return this.println(keyword);
    }

    @Override
    public MCDOutput printOperator(String operator) throws IOException {
        return this.print(operator);
    }

    @Override
    public MCDOutput printlnOperator(String operator) throws IOException {
        return this.println(operator);
    }

    @Override
    public MCDOutput printLabel(String label) throws IOException {
        return this.print(label);
    }

    @Override
    public MCDOutput printlnLabel(String label) throws IOException {
        return this.println(label);
    }

    @Override
    public MCDOutput printError(String error) throws IOException {
        return this.print(error);
    }

    @Override
    public MCDOutput printlnError(String error) throws IOException {
        return this.println(error);
    }

    private void ensureNotClosed() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    private void printIndentIfNeeded() {
        if (this.newLine) {
            for (int indentCount = 0; indentCount < this.indentLevel; ++indentCount) {
                this.pw.print(INDENT);
            }
            this.newLine = false;
        }
    }
}

