/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd;

import de.carne.mcd.MCDOutput;
import de.carne.mcd.io.MCDInputBuffer;
import de.carne.mcd.io.MCDOutputBuffer;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import org.eclipse.jdt.annotation.Nullable;

public abstract class MachineCodeDecoder {
    private static final ThreadLocal<@Nullable MachineCodeDecoder> ACTIVE_DECODER_HOLDER = new ThreadLocal();
    private final String name;
    private ByteOrder byteOrder;
    private long defaultLimit;

    protected MachineCodeDecoder(String name, ByteOrder byteOrder, long defaultLimit) {
        this.name = name;
        this.byteOrder = byteOrder;
        this.defaultLimit = defaultLimit;
    }

    public static MachineCodeDecoder getDecoder() {
        MachineCodeDecoder activeDecoder = ACTIVE_DECODER_HOLDER.get();
        if (activeDecoder == null) {
            throw new IllegalStateException("Decoder only accessible during decode call");
        }
        return activeDecoder;
    }

    public static <T extends MachineCodeDecoder> T getDecoder(Class<T> decoderType) {
        MachineCodeDecoder activeDecoder = MachineCodeDecoder.getDecoder();
        Class<?> activeDecoderType = activeDecoder.getClass();
        if (!decoderType.isAssignableFrom(activeDecoderType)) {
            throw new IllegalStateException("Decoder type mismatch: " + activeDecoderType.getName());
        }
        return (T)((MachineCodeDecoder)decoderType.cast(activeDecoder));
    }

    public String name() {
        return this.name;
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public long defaultLimit() {
        return this.defaultLimit;
    }

    public void setDefaultLimit(long defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    public long decode(ReadableByteChannel in, MCDOutput out) throws IOException {
        return this.decode(in, out, 0L, Long.MAX_VALUE);
    }

    public long decode(ReadableByteChannel in, MCDOutput out, long offset) throws IOException {
        return this.decode(in, out, offset, this.defaultLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decode(ReadableByteChannel in, MCDOutput out, long offset, long limit) throws IOException {
        long decoded;
        @Nullable MachineCodeDecoder savedDecoder = ACTIVE_DECODER_HOLDER.get();
        ACTIVE_DECODER_HOLDER.set(this);
        try {
            decoded = this.decode0(new MCDInputBuffer(in, this.byteOrder), new MCDOutputBuffer(out), offset, limit);
        }
        finally {
            if (savedDecoder != null) {
                ACTIVE_DECODER_HOLDER.set(savedDecoder);
            } else {
                ACTIVE_DECODER_HOLDER.remove();
            }
        }
        return decoded;
    }

    protected abstract long decode0(MCDInputBuffer var1, MCDOutputBuffer var2, long var3, long var5) throws IOException;
}

