/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.util;

import org.eclipse.jdt.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public final class ProjectLogger {
    private static final ThreadLocal<@Nullable Logger> LOGGER_HOLDER = new ThreadLocal();
    private static final Logger DEFAULT_LOGGER = new Logger(){
        private static final String TRACE_NAME = "TRACE";

        public String getName() {
            return this.getClass().getSimpleName();
        }

        public boolean isTraceEnabled() {
            return true;
        }

        public void trace(@Nullable String msg) {
            this.log(TRACE_NAME, msg);
        }

        public void trace(@Nullable String format, @Nullable Object arg) {
            this.log(TRACE_NAME, format, arg);
        }

        public void trace(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.log(TRACE_NAME, format, arg1, arg2);
        }

        public void trace(@Nullable String format, Object ... arguments) {
            this.log(TRACE_NAME, format, arguments);
        }

        public void trace(@Nullable String msg, @Nullable Throwable t) {
            this.log(TRACE_NAME, msg, t);
        }

        public boolean isTraceEnabled(@Nullable Marker marker) {
            return true;
        }

        public void trace(@Nullable Marker marker, @Nullable String msg) {
            this.log(TRACE_NAME, msg);
        }

        public void trace(@Nullable Marker marker, @Nullable String format, @Nullable Object arg) {
            this.log(TRACE_NAME, format, arg);
        }

        public void trace(@Nullable Marker marker, @Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.log(TRACE_NAME, format, arg1, arg2);
        }

        public void trace(@Nullable Marker marker, @Nullable String format, Object ... argArray) {
            this.log(TRACE_NAME, format, argArray);
        }

        public void trace(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
            this.log(TRACE_NAME, msg, t);
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public void debug(@Nullable String msg) {
            this.log(LogLevel.DEBUG.name(), msg);
        }

        public void debug(@Nullable String format, @Nullable Object arg) {
            this.log(LogLevel.DEBUG.name(), format, arg);
        }

        public void debug(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.log(LogLevel.DEBUG.name(), format, arg1, arg2);
        }

        public void debug(@Nullable String msg, @Nullable Throwable t) {
            this.log(LogLevel.DEBUG.name(), msg, t);
        }

        public boolean isDebugEnabled(@Nullable Marker marker) {
            return true;
        }

        public void debug(@Nullable Marker marker, @Nullable String msg) {
            this.log(LogLevel.DEBUG.name(), msg);
        }

        public void debug(@Nullable Marker marker, @Nullable String format, @Nullable Object arg) {
            this.log(LogLevel.DEBUG.name(), format, arg);
        }

        public void debug(@Nullable Marker marker, @Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.log(LogLevel.DEBUG.name(), format, arg1, arg2);
        }

        public void debug(@Nullable Marker marker, @Nullable String format, Object ... arguments) {
            this.log(LogLevel.DEBUG.name(), format, arguments);
        }

        public void debug(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
            this.log(LogLevel.DEBUG.name(), msg, t);
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public void info(@Nullable String msg) {
            this.log(LogLevel.INFO.name(), msg);
        }

        public void info(@Nullable String format, @Nullable Object arg) {
            this.log(LogLevel.INFO.name(), format, arg);
        }

        public void info(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.log(LogLevel.INFO.name(), format, arg1, arg2);
        }

        public void info(@Nullable String msg, @Nullable Throwable t) {
            this.log(LogLevel.INFO.name(), msg, t);
        }

        public boolean isInfoEnabled(@Nullable Marker marker) {
            return true;
        }

        public void info(@Nullable Marker marker, @Nullable String msg) {
            this.log(LogLevel.INFO.name(), msg);
        }

        public void info(@Nullable Marker marker, @Nullable String format, @Nullable Object arg) {
            this.log(LogLevel.INFO.name(), format, arg);
        }

        public void info(@Nullable Marker marker, @Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.log(LogLevel.INFO.name(), format, arg1, arg2);
        }

        public void info(@Nullable Marker marker, @Nullable String format, Object ... arguments) {
            this.log(LogLevel.INFO.name(), format, arguments);
        }

        public void info(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
            this.log(LogLevel.INFO.name(), msg, t);
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public void warn(@Nullable String msg) {
            this.log(LogLevel.WARN.name(), msg);
        }

        public void warn(@Nullable String format, @Nullable Object arg) {
            this.log(LogLevel.WARN.name(), format, arg);
        }

        public void warn(@Nullable String format, Object ... arguments) {
            this.log(LogLevel.WARN.name(), format, arguments);
        }

        public void warn(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.log(LogLevel.WARN.name(), format, arg1, arg2);
        }

        public void warn(@Nullable String msg, @Nullable Throwable t) {
            this.log(LogLevel.WARN.name(), msg, t);
        }

        public boolean isWarnEnabled(@Nullable Marker marker) {
            return true;
        }

        public void warn(@Nullable Marker marker, @Nullable String msg) {
            this.log(LogLevel.WARN.name(), msg);
        }

        public void warn(@Nullable Marker marker, @Nullable String format, @Nullable Object arg) {
            this.log(LogLevel.WARN.name(), format, arg);
        }

        public void warn(@Nullable Marker marker, @Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.log(LogLevel.WARN.name(), format, arg1, arg2);
        }

        public void warn(@Nullable Marker marker, @Nullable String format, Object ... arguments) {
            this.log(LogLevel.WARN.name(), format, arguments);
        }

        public void warn(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
            this.log(LogLevel.WARN.name(), msg, t);
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public void error(@Nullable String msg) {
            this.log(LogLevel.ERROR.name(), msg);
        }

        public void error(@Nullable String format, @Nullable Object arg) {
            this.log(LogLevel.ERROR.name(), format, arg);
        }

        public void error(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.log(LogLevel.ERROR.name(), format, arg1, arg2);
        }

        public void error(@Nullable String format, Object ... arguments) {
            this.log(LogLevel.ERROR.name(), format, arguments);
        }

        public void error(@Nullable String msg, @Nullable Throwable t) {
            this.log(LogLevel.ERROR.name(), msg, t);
        }

        public boolean isErrorEnabled(@Nullable Marker marker) {
            return true;
        }

        public void error(@Nullable Marker marker, @Nullable String msg) {
            this.log(LogLevel.ERROR.name(), msg);
        }

        public void error(@Nullable Marker marker, @Nullable String format, @Nullable Object arg) {
            this.log(LogLevel.ERROR.name(), format, arg);
        }

        public void error(@Nullable Marker marker, @Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.log(LogLevel.ERROR.name(), format, arg1, arg2);
        }

        public void error(@Nullable Marker marker, @Nullable String format, Object ... arguments) {
            this.log(LogLevel.ERROR.name(), format, arguments);
        }

        public void error(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
            this.log(LogLevel.ERROR.name(), msg, t);
        }

        public void debug(@Nullable String message, Object ... objects) {
            this.log(LogLevel.DEBUG.name(), message, objects);
        }

        public void info(@Nullable String message, Object ... objects) {
            this.log(LogLevel.INFO.name(), message, objects);
        }

        public void log(String level, @Nullable String message) {
            System.out.println(level + ": " + message);
        }

        public void log(String level, @Nullable String message, Object ... objects) {
            this.log(level, MessageFormatter.arrayFormat((String)message, (Object[])objects).getMessage());
        }

        public void log(String level, @Nullable String message, @Nullable Throwable throwable) {
            this.log(level, message);
            if (throwable != null) {
                throwable.printStackTrace(System.out);
            }
        }
    };

    private ProjectLogger() {
    }

    public static void enterProject(Project project) {
        LOGGER_HOLDER.set((Logger)project.getLogger());
    }

    public static void leaveProject() {
        LOGGER_HOLDER.remove();
    }

    public static void error(String format, Object ... arguments) {
        ProjectLogger.getLogger().error(format, arguments);
    }

    public static void error(String message, Throwable exception) {
        ProjectLogger.getLogger().error(message, exception);
    }

    public static void warn(String format, Object ... arguments) {
        ProjectLogger.getLogger().warn(format, arguments);
    }

    public static void warn(String message, Throwable exception) {
        ProjectLogger.getLogger().warn(message, exception);
    }

    public static void info(String format, Object ... arguments) {
        ProjectLogger.getLogger().info(format, arguments);
    }

    public static void info(String message, Throwable exception) {
        ProjectLogger.getLogger().info(message, exception);
    }

    public static void debug(String format, Object ... arguments) {
        ProjectLogger.getLogger().debug(format, arguments);
    }

    public static void debug(String message, Throwable exception) {
        ProjectLogger.getLogger().debug(message, exception);
    }

    public static void trace(String format, Object ... arguments) {
        ProjectLogger.getLogger().trace(format, arguments);
    }

    public static void trace(String message, Throwable exception) {
        ProjectLogger.getLogger().trace(message, exception);
    }

    private static Logger getLogger() {
        Logger logger = LOGGER_HOLDER.get();
        return logger != null ? logger : DEFAULT_LOGGER;
    }
}

