/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public class OutputWriter
extends Writer {
    private final BufferedWriter out;
    private final char[] lineSeparator;

    public OutputWriter(File file, boolean append, String encoding, String lineSeparator) throws IOException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), Charset.forName(encoding)), lineSeparator);
    }

    public OutputWriter(Writer out, String lineSeparator) throws IOException {
        this.out = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        this.lineSeparator = lineSeparator.toCharArray();
    }

    @Override
    public void write(char @Nullable [] cbuf, int off, int len) throws IOException {
        Objects.requireNonNull(cbuf);
        int lastOff = off;
        int nextOff = off;
        int nextOffLimit = off + len;
        while (nextOff < nextOffLimit) {
            if (nextOff + 1 < nextOffLimit && cbuf[nextOff] == '\r' && cbuf[nextOff + 1] == '\n') {
                this.writeln(cbuf, lastOff, nextOff - lastOff);
                lastOff = nextOff += 2;
                continue;
            }
            if (cbuf[nextOff] == '\n' || cbuf[nextOff] == '\r') {
                this.writeln(cbuf, lastOff, nextOff - lastOff);
                lastOff = ++nextOff;
                continue;
            }
            ++nextOff;
        }
        this.out.write(cbuf, lastOff, nextOff - lastOff);
    }

    private void writeln(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            this.out.write(cbuf, off, len);
        }
        this.out.write(this.lineSeparator);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

