/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.util;

import java.util.HashMap;
import java.util.Map;

public final class JavaOutput {
    private static final Map<Character, String> ENCODE_BUNDLE_STRING_MAP = new HashMap<Character, String>();

    private JavaOutput() {
    }

    public static String mangleBundleKey(String bundleKey) {
        StringBuilder mangled = new StringBuilder();
        int bundleKeyLength = bundleKey.length();
        boolean nextUpperCase = false;
        for (int chIndex = 0; chIndex < bundleKeyLength; ++chIndex) {
            char ch = bundleKey.charAt(chIndex);
            if (ch == '_') {
                nextUpperCase = true;
                continue;
            }
            if (nextUpperCase) {
                nextUpperCase = false;
                mangled.append(Character.toUpperCase(ch));
                continue;
            }
            mangled.append(Character.toLowerCase(ch));
        }
        return mangled.toString();
    }

    public static String encodeBundleString(String bundleString) {
        StringBuilder encoded = new StringBuilder();
        bundleString.chars().forEachOrdered(code -> {
            String mappedCode = ENCODE_BUNDLE_STRING_MAP.get(Character.valueOf((char)code));
            if (mappedCode != null) {
                encoded.append(mappedCode);
            } else if (32 <= code && code <= 126) {
                encoded.append((char)code);
            } else {
                encoded.append("&#").append(code).append(';');
            }
        });
        return encoded.toString();
    }

    static {
        ENCODE_BUNDLE_STRING_MAP.put(Character.valueOf('\r'), "");
        ENCODE_BUNDLE_STRING_MAP.put(Character.valueOf('\n'), "<br>");
        ENCODE_BUNDLE_STRING_MAP.put(Character.valueOf('<'), "&lt;");
        ENCODE_BUNDLE_STRING_MAP.put(Character.valueOf('>'), "&gt;");
        ENCODE_BUNDLE_STRING_MAP.put(Character.valueOf('&'), "&amp;");
        ENCODE_BUNDLE_STRING_MAP.put(Character.valueOf('\"'), "&quot;");
        ENCODE_BUNDLE_STRING_MAP.put(Character.valueOf('\''), "&#39;");
        ENCODE_BUNDLE_STRING_MAP.put(Character.valueOf('/'), "&frasl;");
        ENCODE_BUNDLE_STRING_MAP.put(Character.valueOf('@'), "&commat;");
        ENCODE_BUNDLE_STRING_MAP.put(Character.valueOf('*'), "&#42;");
    }
}

