/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public interface GitHubApi {
    @GET
    @Path(value="/repos/{owner}/{repo}/releases")
    @Produces(value={"application/json"})
    public List<ReleaseInfo> listReleases(@PathParam(value="owner") String var1, @PathParam(value="repo") String var2, @QueryParam(value="page") int var3);

    @GET
    @Path(value="/repos/{owner}/{repo}/releases/{releaseId}")
    @Produces(value={"application/json"})
    public ReleaseInfo getRelease(@PathParam(value="owner") String var1, @PathParam(value="repo") String var2, @PathParam(value="releaseId") String var3);

    @DELETE
    @Path(value="/repos/{owner}/{repo}/releases/{releaseId}")
    public void deleteRelease(@PathParam(value="owner") String var1, @PathParam(value="repo") String var2, @PathParam(value="releaseId") String var3);

    @POST
    @Path(value="/repos/{owner}/{repo}/releases")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ReleaseInfo createRelease(@PathParam(value="owner") String var1, @PathParam(value="repo") String var2, CreateOrEditReleaseRequest var3);

    public static class CreateOrEditReleaseRequest {
        @JsonProperty(value="tag_name")
        public @Nullable String tagName;
        @JsonProperty(value="target_commitish")
        public @Nullable String targetCommitish;
        @JsonProperty(value="name")
        public @Nullable String name;
        @JsonProperty(value="body")
        public @Nullable String body;
        @JsonProperty(value="draft")
        public boolean draft;
        @JsonProperty(value="prerelease")
        public boolean prerelease;
    }

    public static class ReleaseAssetInfo {
        @JsonProperty(value="url")
        public @Nullable String url;
        @JsonProperty(value="browser_download_url")
        public @Nullable String browserDownloadUrl;
        @JsonProperty(value="id")
        public @Nullable String id;
        @JsonProperty(value="node_id")
        public @Nullable String nodeId;
        @JsonProperty(value="name")
        public @Nullable String name;
        @JsonProperty(value="label")
        public @Nullable String label;
        @JsonProperty(value="state")
        public @Nullable String state;
        @JsonProperty(value="content_type")
        public @Nullable String contentType;
        @JsonProperty(value="size")
        public long size;
        @JsonProperty(value="download_count")
        public int downloadCount;
        @JsonProperty(value="created_at")
        public @Nullable String createdAt;
        @JsonProperty(value="updated_at")
        public @Nullable String updatedAt;
        @JsonProperty(value="uploader")
        public @Nullable ReleaseUserInfo uploader;
    }

    public static class ReleaseUserInfo {
        @JsonProperty(value="login")
        public @Nullable String login;
        @JsonProperty(value="id")
        public @Nullable String id;
        @JsonProperty(value="node_id")
        public @Nullable String nodeId;
        @JsonProperty(value="avatar_url")
        public @Nullable String avatarUrl;
        @JsonProperty(value="gravatar_id")
        public @Nullable String gravatarId;
        @JsonProperty(value="url")
        public @Nullable String url;
        @JsonProperty(value="html_url")
        public @Nullable String htmlUrl;
        @JsonProperty(value="followers_url")
        public @Nullable String followerUrl;
        @JsonProperty(value="following_url")
        public @Nullable String followingUrl;
        @JsonProperty(value="gists_url")
        public @Nullable String gistsUrl;
        @JsonProperty(value="starred_url")
        public @Nullable String starredUrl;
        @JsonProperty(value="subscriptions_url")
        public @Nullable String subscriptionsUrl;
        @JsonProperty(value="organizations_url")
        public @Nullable String organizationsUrl;
        @JsonProperty(value="repos_url")
        public @Nullable String reposUrl;
        @JsonProperty(value="events_url")
        public @Nullable String eventsUrl;
        @JsonProperty(value="received_events_url")
        public @Nullable String receivedEventsUrl;
        @JsonProperty(value="type")
        public @Nullable String type;
        @JsonProperty(value="site_admin")
        public boolean siteAdmin;
    }

    public static class ReleaseInfo {
        @JsonProperty(value="url")
        public @Nullable String url;
        @JsonProperty(value="html_url")
        public @Nullable String htmlUrl;
        @JsonProperty(value="assets_url")
        public @Nullable String assetsUrl;
        @JsonProperty(value="upload_url")
        public @Nullable String uploadUrl;
        @JsonProperty(value="tarball_url")
        public @Nullable String tarballUrl;
        @JsonProperty(value="zipball_url")
        public @Nullable String zipballUrl;
        @JsonProperty(value="id")
        public @Nullable String id;
        @JsonProperty(value="node_id")
        public @Nullable String nodeId;
        @JsonProperty(value="tag_name")
        public @Nullable String tagName;
        @JsonProperty(value="target_commitish")
        public @Nullable String targetCommitish;
        @JsonProperty(value="name")
        public @Nullable String name;
        @JsonProperty(value="body")
        public @Nullable String body;
        @JsonProperty(value="draft")
        public boolean draft;
        @JsonProperty(value="prerelease")
        public boolean prerelease;
        @JsonProperty(value="created_at")
        public @Nullable String createdAt;
        @JsonProperty(value="published_at")
        public @Nullable String publishedAt;
        @JsonProperty(value="author")
        public @Nullable ReleaseUserInfo author;
        @JsonProperty(value="assets")
        public @Nullable List<ReleaseAssetInfo> assets = null;
    }

    public static class ResponseStatus {
        @JsonProperty(value="message")
        public @Nullable String message;
        @JsonProperty(value="documentation_url")
        public @Nullable String documentationUrl;
    }
}

