/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.util;

import de.carne.gradle.plugin.java.util.ExecOut;
import de.carne.gradle.plugin.java.util.ProjectLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;

abstract class ExecWrapper {
    private final File directory;
    private final String command;

    protected ExecWrapper(File directory, String command) {
        this.directory = directory;
        this.command = command;
    }

    protected int executeCommand(ExecOut out, String ... args) throws IOException, InterruptedException {
        ArrayList<@Nullable String> processCommand = new ArrayList<String>(1 + args.length);
        processCommand.add(this.command);
        processCommand.addAll(Arrays.asList(args));
        ProjectLogger.info("Executing command: {}", String.join((CharSequence)" ", processCommand));
        ProjectLogger.info("Working directory: {}", this.directory);
        Process process = new ProcessBuilder(processCommand).directory(this.directory).start();
        try (BufferedReader processReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String processLine;
            while ((processLine = processReader.readLine()) != null) {
                out.accept(processLine);
            }
        }
        return process.waitFor();
    }

    static String executeVersionCommand(File directory, String command, String ... args) throws IOException, InterruptedException {
        ExecWrapper wrapper = new ExecWrapper(directory, command){};
        VersionOut version = new VersionOut();
        wrapper.executeCommand(version, args);
        return version.get();
    }

    private static class VersionOut
    implements ExecOut,
    Supplier<String> {
        private @Nullable String value = null;

        VersionOut() {
        }

        @Override
        public void accept(String processLine) throws IOException {
            if (this.value != null) {
                throw new IOException("Unexpected process output: " + processLine);
            }
            this.value = processLine;
        }

        @Override
        public String get() {
            return Objects.requireNonNull(this.value);
        }
    }
}

