/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.ext.GenerateI18N;
import de.carne.gradle.plugin.java.ext.JavaToolsExtension;
import de.carne.gradle.plugin.java.task.JavaToolsTask;
import de.carne.gradle.plugin.java.util.JavaOutput;
import de.carne.gradle.plugin.java.util.OutputWriter;
import de.carne.gradle.plugin.java.util.Plugins;
import de.carne.gradle.plugin.java.util.ProjectLogger;
import de.carne.gradle.plugin.java.util.Strings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.api.tasks.compile.JavaCompile;

public class GenerateI18NTask
extends DefaultTask
implements JavaToolsTask {
    private static final ResourceBundle TEMPLATES = ResourceBundle.getBundle(GenerateI18NTask.class.getName());
    private static final String GENERATE_I18N_TASK_GROUP = "build";
    private static final String GENERATE_I18N_TASK_NAME = "generateI18N";
    private static final String GENERATE_I18N_TASK_DESCRIPTION = "Create/update I18N helper classes.";

    public static GenerateI18NTask create(Project project) {
        project.getLogger().info("Creating task generateI18N");
        return (GenerateI18NTask)project.getTasks().create(GENERATE_I18N_TASK_NAME, GenerateI18NTask.class);
    }

    @Override
    public void apply(Project project) {
        this.setGroup(GENERATE_I18N_TASK_GROUP);
        this.setDescription(GENERATE_I18N_TASK_DESCRIPTION);
    }

    @Override
    public void afterEvaluate(Project project) {
        GenerateI18N generateI18N = ((JavaToolsExtension)project.getExtensions().getByType(JavaToolsExtension.class)).getGenerateI18N();
        boolean enabled = generateI18N.isEnabled();
        this.setEnabled(enabled);
        if (enabled) {
            Plugins.checkJavaApplied(project);
            this.getInputs().files(new Object[]{generateI18N.getBundles()});
            this.getOutputs().dir((Object)generateI18N.getGenDir());
            this.processBundleFiles(generateI18N.getBundles(), (srcDir, bundleFile) -> {
                File javaFile = this.getAbsoluteFile(generateI18N.getGenDir(), this.getJavaFile((File)bundleFile));
                project.getLogger().info("{} output file {}", (Object)GENERATE_I18N_TASK_NAME, (Object)javaFile);
                this.getOutputs().file((Object)javaFile);
            });
            Plugins.setTasksDependsOn(project, JavaCompile.class, (Task)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void executeGenerateI18N() {
        Project project = this.getProject();
        ProjectLogger.enterProject(project);
        try {
            GenerateI18N generateI18N = ((JavaToolsExtension)project.getExtensions().getByType(JavaToolsExtension.class)).getGenerateI18N();
            Pattern keyFilter = Pattern.compile(generateI18N.getKeyFilter());
            this.processBundleFiles(generateI18N.getBundles(), (srcDir, bundleFile) -> {
                try {
                    this.generateJavaFile((File)srcDir, (File)bundleFile, generateI18N.getGenDir(), keyFilter, generateI18N.getEncoding(), generateI18N.getLineSeparator());
                }
                catch (IOException e) {
                    throw new TaskExecutionException((Task)this, (Throwable)e);
                }
            });
        }
        finally {
            ProjectLogger.leaveProject();
        }
    }

    private void processBundleFiles(ConfigurableFileTree fileTree, BiConsumer<File, File> consumer) {
        File srcDir = fileTree.getDir();
        fileTree.forEach(bundleFile -> consumer.accept(srcDir, this.getRelativeFile(srcDir, Objects.requireNonNull(bundleFile))));
    }

    private File getRelativeFile(File baseDir, File file) {
        Path baseDirPath = baseDir.toPath();
        Path filePath = file.toPath();
        return baseDirPath.relativize(filePath).toFile();
    }

    private File getAbsoluteFile(File baseDir, File file) {
        Path baseDirPath = baseDir.toPath();
        Path filePath = file.toPath();
        return baseDirPath.resolve(filePath).toAbsolutePath().toFile();
    }

    private File getJavaFile(File bundleFile) {
        File bundleFileParent = bundleFile.getParentFile();
        String bundleFileName = bundleFile.getName();
        int extensionIndex = bundleFileName.lastIndexOf(46);
        String javaFileName = 0 < extensionIndex && extensionIndex < bundleFileName.length() ? bundleFileName.substring(0, extensionIndex) + ".java" : bundleFileName;
        return new File(bundleFileParent, javaFileName);
    }

    private void generateJavaFile(File srcDir, File bundleFile, File genDir, Pattern keyFilter, String encoding, String lineSeparator) throws IOException {
        File absoluteBundleFile = this.getAbsoluteFile(srcDir, bundleFile);
        File javaFile = this.getJavaFile(bundleFile);
        File absoluteJavaFile = this.getAbsoluteFile(genDir, javaFile);
        Files.createDirectories(absoluteJavaFile.toPath().getParent(), new FileAttribute[0]);
        try (FileReader bundleReader = new FileReader(absoluteBundleFile);
             OutputWriter javaWriter = new OutputWriter(absoluteJavaFile, false, encoding, lineSeparator);){
            Properties bundle = new Properties();
            bundle.load(bundleReader);
            ArrayList<String> bundleKeys = new ArrayList<String>(bundle.stringPropertyNames());
            bundleKeys.sort(String::compareTo);
            this.generateJavaHeader(javaWriter, bundleFile, javaFile);
            for (String bundleKey : bundleKeys) {
                if (!keyFilter.matcher(bundleKey).matches()) continue;
                String bundleString = Objects.requireNonNull(bundle.getProperty(bundleKey));
                this.generateJavaBody(javaWriter, bundleKey, bundleString);
            }
            this.generateJavaFooter(javaWriter);
        }
    }

    private void generateJavaHeader(OutputWriter javaWriter, File bundleFile, File javaFile) throws IOException {
        javaWriter.write(TEMPLATES.getString("FILE_HEADER"));
        String javaPackage = Strings.safe(javaFile.getParent()).replace('/', '.').replace('\\', '.');
        String javaClass = javaFile.getName().replaceAll("\\..*", "");
        String normalizedBundleFile = bundleFile.toString().replace('\\', '/');
        if (Strings.notEmpty(javaPackage)) {
            javaWriter.write(MessageFormat.format(TEMPLATES.getString("PACKAGE_STATEMENT"), javaPackage));
        }
        javaWriter.write(MessageFormat.format(TEMPLATES.getString("CLASS_START"), normalizedBundleFile, javaClass));
    }

    private void generateJavaBody(OutputWriter javaWriter, String bundleKey, String bundleString) throws IOException {
        String mangledBundleKey = JavaOutput.mangleBundleKey(bundleKey);
        String encodedBundleString = JavaOutput.encodeBundleString(bundleString);
        javaWriter.write(MessageFormat.format(TEMPLATES.getString("CLASS_BODY"), bundleKey, mangledBundleKey, encodedBundleString));
    }

    private void generateJavaFooter(OutputWriter javaWriter) throws IOException {
        javaWriter.write(MessageFormat.format(TEMPLATES.getString("CLASS_END"), new Object[]{new Object[0]}));
    }
}

