/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.task.DependencyHolder;
import de.carne.gradle.plugin.java.task.DependencyKey;
import java.util.Objects;
import java.util.TreeMap;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.initialization.dsl.ScriptHandler;

class DependencyMap
extends TreeMap<DependencyKey, DependencyHolder> {
    private static final long serialVersionUID = -3996197953181906688L;

    private DependencyMap(Project project, ScriptHandler buildscript) {
        this.addConfigurations(project, buildscript.getConfigurations());
    }

    private DependencyMap(Project project) {
        this.addConfigurations(project, project.getConfigurations());
    }

    public static DependencyMap fromProject(Project project) {
        return new DependencyMap(project);
    }

    public static DependencyMap fromBuildscript(Project project) {
        return new DependencyMap(project, project.getBuildscript());
    }

    private void addConfigurations(Project project, ConfigurationContainer configurations) {
        configurations.forEach(configuration -> this.addConfiguration(project, Objects.requireNonNull(configuration)));
    }

    private void addConfiguration(Project project, Configuration configuration) {
        configuration.getDependencies().forEach(dependency -> this.addDependency(project, configuration, Objects.requireNonNull(dependency)));
    }

    private void addDependency(Project project, Configuration configuration, Dependency dependency) {
        if (dependency instanceof ExternalDependency) {
            DependencyHolder dependencyHolder = new DependencyHolder(project, configuration, (ExternalDependency)dependency);
            this.put(dependencyHolder, dependencyHolder);
        }
    }
}

