/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.ext;

import de.carne.gradle.plugin.java.ext.GenerateI18N;
import de.carne.gradle.plugin.java.ext.GitHubRelease;
import de.carne.gradle.plugin.java.ext.Node;
import de.carne.gradle.plugin.java.ext.PlatformInfo;
import org.gradle.api.Action;
import org.gradle.api.Project;

public class JavaToolsExtension {
    private static final String JAVA_TOOLS_EXTENSION_NAME = "javatools";
    private final Project project;
    private final PlatformInfo platformInfo = new PlatformInfo();
    private final GenerateI18N generateI18NConfig;
    private final GitHubRelease githubRelease;
    private final Node node;

    public static JavaToolsExtension create(Project project) {
        return (JavaToolsExtension)project.getExtensions().create(JAVA_TOOLS_EXTENSION_NAME, JavaToolsExtension.class, new Object[]{project});
    }

    public JavaToolsExtension(Project project) {
        this.project = project;
        this.generateI18NConfig = new GenerateI18N(this.project);
        this.githubRelease = new GitHubRelease(this.project);
        this.node = new Node(this.project);
    }

    public PlatformInfo getPlatform() {
        return this.platformInfo;
    }

    public GenerateI18N getGenerateI18N() {
        return this.generateI18NConfig;
    }

    public GitHubRelease getGithubRelease() {
        return this.githubRelease;
    }

    public Node getNode() {
        return this.node;
    }

    public void generateI18N(Action<? super GenerateI18N> configuration) {
        this.generateI18NConfig.setEnabled(false);
        configuration.execute((Object)this.generateI18NConfig);
    }

    public void githubRelease(Action<? super GitHubRelease> configuration) {
        this.githubRelease.setEnabled(false);
        configuration.execute((Object)this.githubRelease);
    }

    public void node(Action<? super Node> configuration) {
        this.node.setEnabled(false);
        configuration.execute((Object)this.node);
    }
}

