/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.ext;

import java.io.File;
import org.eclipse.jdt.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;

public class GitHubRelease {
    private final Project project;
    private boolean enabledParam = false;
    private @Nullable String releaseNameParam;
    private @Nullable File releaseNotesParam;
    private @Nullable ConfigurableFileTree releaseAssetsParam;
    private boolean overwriteParam = false;
    private @Nullable String githubTokenParam;
    private boolean ignoreDirtyParam = false;

    public GitHubRelease(Project project) {
        this.project = project;
        Object versionProperty = this.project.getProperties().get("version");
        if (versionProperty != null) {
            this.releaseNameParam = "v" + versionProperty;
            this.releaseNotesParam = this.project.file((Object)("RELEASE-" + this.releaseNameParam + ".md"));
        }
    }

    public boolean isEnabled() {
        return this.enabledParam;
    }

    public void setEnabled(boolean enabled) {
        this.enabledParam = enabled;
    }

    public String getReleaseName() {
        String checkedReleaseName = this.releaseNameParam;
        if (checkedReleaseName == null) {
            throw new GradleException("Property releaseName not set");
        }
        return checkedReleaseName;
    }

    public void setReleaseName(String releaseName) {
        this.releaseNameParam = releaseName;
    }

    public File getReleaseNotes() {
        File checkedReleaseNotes = this.releaseNotesParam;
        if (checkedReleaseNotes == null) {
            throw new GradleException("Property releaseNotes not set");
        }
        return checkedReleaseNotes;
    }

    public void setReleaseNotes(File releaseNotes) {
        this.releaseNotesParam = releaseNotes;
    }

    public ConfigurableFileTree getReleaseAssets() {
        ConfigurableFileTree checkedReleaseAssets = this.releaseAssetsParam;
        if (checkedReleaseAssets == null) {
            throw new GradleException("Property releaseAssets not set");
        }
        return checkedReleaseAssets;
    }

    public void setReleaseAssets(ConfigurableFileTree releaseAssets) {
        this.releaseAssetsParam = releaseAssets;
    }

    public boolean isOverwrite() {
        return this.overwriteParam;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwriteParam = overwrite;
    }

    public String getGithubToken() {
        String checkedGithubtoken = this.githubTokenParam;
        if (checkedGithubtoken == null) {
            throw new GradleException("Property githubToken not set");
        }
        return checkedGithubtoken;
    }

    public void setGithubToken(String githubToken) {
        this.githubTokenParam = githubToken;
    }

    public boolean isIgnoreDirty() {
        return this.ignoreDirtyParam;
    }

    public void setIgnoreDirty(boolean ignoreDirty) {
        this.ignoreDirtyParam = ignoreDirty;
    }
}

