/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.ext;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;

public class GenerateI18N {
    private final Project project;
    private boolean enabledParam = false;
    private String keyFilterParam = "^I18N_.*";
    private File genDirParam;
    private ConfigurableFileTree bundlesParam;
    private String lineSeparatorParam = System.getProperty("line.separator", "\n");
    private String encodingParam = System.getProperty("file.encoding", "UTF-8");

    public GenerateI18N(Project project) {
        this.project = project;
        this.genDirParam = GenerateI18N.getGenDirDefault(project);
        this.bundlesParam = GenerateI18N.getBundlesDefault(this.project, "src/main/resources", "**/*I18N.properties");
    }

    private static File getGenDirDefault(Project project) {
        return new File(project.getBuildDir(), "/generated-src/i18n/main/java");
    }

    private static ConfigurableFileTree getBundlesDefault(Project project, String srcDir, String include) {
        ConfigurableFileTree bundles = project.fileTree((Object)srcDir);
        bundles.include(new String[]{include});
        return bundles;
    }

    public boolean isEnabled() {
        return this.enabledParam;
    }

    public void setEnabled(boolean enabled) {
        this.enabledParam = enabled;
    }

    public String getKeyFilter() {
        return this.keyFilterParam;
    }

    public void setKeyFilter(String keyFilter) {
        this.keyFilterParam = keyFilter;
    }

    public File getGenDir() {
        return this.genDirParam;
    }

    public void setGenDir(File genDir) {
        this.genDirParam = genDir;
    }

    public ConfigurableFileTree getBundles() {
        return this.bundlesParam;
    }

    public void setBundles(ConfigurableFileTree bundles) {
        this.bundlesParam = bundles;
    }

    public String getLineSeparator() {
        return this.lineSeparatorParam;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparatorParam = lineSeparator;
    }

    public String getEncoding() {
        return this.encodingParam;
    }

    public void setEncoding(String encoding) {
        this.encodingParam = encoding;
    }
}

