/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.util;

import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.UnknownPluginException;

public final class Plugins {
    private Plugins() {
    }

    public static void checkJavaApplied(Project project) {
        try {
            project.getPlugins().getPlugin("java");
        }
        catch (UnknownPluginException e) {
            String message = "Unable to apply plugin de.carne.java-tools; please apply java or java-library plugin first";
            project.getLogger().error(message);
            throw new GradleException(message, (Throwable)e);
        }
    }

    public static void setTasksDependsOn(Project project, Class<? extends Task> taskType, Task dependency) {
        project.getTasks().stream().filter(task -> taskType.isAssignableFrom(task.getClass())).forEach(task -> task.dependsOn(new Object[]{dependency}));
    }

    public static void setTaskDependsOn(Project project, String taskName, Task dependency) {
        project.getTasks().stream().filter(task -> taskName.equals(task.getName())).forEach(task -> task.dependsOn(new Object[]{dependency}));
    }
}

