/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.util;

import de.carne.gradle.plugin.java.util.ExecOut;
import de.carne.gradle.plugin.java.util.ExecWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

public final class NpmWrapper
extends ExecWrapper {
    private final String version;

    private NpmWrapper(File directory, String command, String version) {
        super(directory, command);
        this.version = version;
    }

    public static NpmWrapper getInstance(File directory, String command) throws IOException, InterruptedException {
        String version = ExecWrapper.executeVersionCommand(directory, command, "-v");
        return new NpmWrapper(directory, command, version);
    }

    public String npmVersion() {
        return this.version;
    }

    public int executeNpm(File logFile, String ... arguments) throws IOException, InterruptedException {
        int status;
        try (NpmLog npmLog = new NpmLog(logFile);){
            status = this.executeCommand(npmLog, arguments);
        }
        return status;
    }

    private static class NpmLog
    implements ExecOut,
    AutoCloseable {
        private final PrintStream log;

        NpmLog(File logFile) throws IOException {
            this.log = new PrintStream(Files.newOutputStream(logFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
        }

        @Override
        public void accept(String processLine) throws IOException {
            this.log.println(processLine);
        }

        @Override
        public void close() throws IOException {
            this.log.close();
        }
    }
}

