/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.carne.gradle.plugin.java.util.GitHubApi;
import de.carne.gradle.plugin.java.util.Late;
import de.carne.gradle.plugin.java.util.ProjectLogger;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.jackson.JacksonFeature;

public class GitHubRepo
implements AutoCloseable {
    private static final Pattern GITHUB_REMOTE_URL_PATTERN = Pattern.compile("https://github.com/([a-zA-Z_0-9\\-]+)/([a-zA-Z_0-9\\-]+).git");
    private static final String GITHUB_API_BASE_URI = "https://api.github.com";
    private final File dir;
    private final String owner;
    private final String repo;
    private final String branch;
    private final String token;
    private final boolean dirty;
    private Late<Client> clientHolder = new Late();
    private Late<GitHubApi> apiHolder = new Late();
    private static final String[] FILE_TYPE_MAP = new String[]{".exe", "application/vnd.microsoft.portable-executable", ".gz", "application/gzip", ".html", "text/html", ".jar", "application/zip", ".md", "text/markdown", ".xml", "xml/xml", ".zip", "application/zip", "", "application/binary"};

    public GitHubRepo(String dir, String token) throws IOException {
        this(new File(dir), token);
    }

    public GitHubRepo(File dir, String token) throws IOException {
        this.dir = dir.getAbsoluteFile();
        ProjectLogger.info("Accessing GitHub repository at '{}'...", this.dir);
        try (Git git = Git.open((File)dir);
             Repository repository = git.getRepository();){
            String remoteUrl = repository.getConfig().getString("remote", "origin", "url");
            ProjectLogger.debug("  Remote URL: {}", remoteUrl);
            Matcher remoteUrlMatcher = GITHUB_REMOTE_URL_PATTERN.matcher(remoteUrl);
            if (!remoteUrlMatcher.matches()) {
                throw new IOException("Unexpected remote url: " + remoteUrl);
            }
            this.owner = Objects.requireNonNull(remoteUrlMatcher.group(1));
            this.repo = Objects.requireNonNull(remoteUrlMatcher.group(2));
            this.branch = Objects.requireNonNull(repository.getBranch());
            ProjectLogger.debug("  GitHub owner : {}", this.owner);
            ProjectLogger.debug("  GitHub repo  : {}", this.repo);
            ProjectLogger.debug("  GitHub branch: {}", this.branch);
            Status gitStatus = git.status().call();
            this.dirty = gitStatus.hasUncommittedChanges() || !gitStatus.getUntracked().isEmpty();
        }
        catch (GitAPIException e) {
            throw new IOException("A Git exception has occurred", e);
        }
        this.token = token;
    }

    public File dir() {
        return this.dir;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public @Nullable GitHubApi.ReleaseInfo queryRelease(String name) throws IOException {
        this.setupClientIfNeeded();
        ProjectLogger.info("Querying release '{}/{}/{}'...", this.owner, this.repo, name);
        GitHubApi.ReleaseInfo result = null;
        try {
            int page = 1;
            while (true) {
                List<GitHubApi.ReleaseInfo> releaseInfos = this.apiHolder.get().listReleases(this.owner, this.repo, page);
                for (GitHubApi.ReleaseInfo releaseInfo : releaseInfos) {
                    if (!name.equals(releaseInfo.name)) continue;
                    result = releaseInfo;
                    break;
                }
                if (result == null && !releaseInfos.isEmpty()) {
                    ++page;
                    continue;
                }
                break;
            }
        }
        catch (ClientErrorException e) {
            throw new IOException("Failed to query release '" + name + "'", e);
        }
        return result;
    }

    public GitHubApi.ReleaseInfo draftRelease(String name, String body) throws IOException {
        GitHubApi.ReleaseInfo release;
        this.setupClientIfNeeded();
        ProjectLogger.info("Drafting new release '{}/{}/{}@{}'...", this.owner, this.repo, name, this.branch);
        try {
            GitHubApi.CreateOrEditReleaseRequest request = new GitHubApi.CreateOrEditReleaseRequest();
            request.tagName = name;
            request.targetCommitish = this.branch;
            request.name = name;
            request.body = body;
            request.draft = true;
            request.prerelease = name.endsWith("-SNAPSHOT");
            release = this.apiHolder.get().createRelease(this.owner, this.repo, request);
        }
        catch (ClientErrorException e) {
            throw new IOException("Failed to draft new release '" + name + "'", e);
        }
        return release;
    }

    public GitHubApi.ReleaseAssetInfo uploadReleaseAsset(String uploadUrl, File assetFile) throws IOException {
        return this.uploadReleaseAsset(uploadUrl, assetFile, assetFile.getName(), null);
    }

    public GitHubApi.ReleaseAssetInfo uploadReleaseAsset(String uploadUrl, File assetFile, String name) throws IOException {
        return this.uploadReleaseAsset(uploadUrl, assetFile, name, null);
    }

    public GitHubApi.ReleaseAssetInfo uploadReleaseAsset(String uploadUrl, File assetFile, String name, @Nullable String label) throws IOException {
        GitHubApi.ReleaseAssetInfo assetInfo;
        this.setupClientIfNeeded();
        ProjectLogger.info("Uploading release asset '{} -> {}'...", assetFile, uploadUrl);
        UriBuilder targetUri = UriBuilder.fromUri((String)uploadUrl).queryParam("name", new Object[]{name});
        if (label != null) {
            targetUri.queryParam("label", new Object[]{label});
        }
        WebTarget target = this.clientHolder.get().target(targetUri);
        try (FileInputStream assetStream = new FileInputStream(assetFile);
             Response response = target.request(new String[]{"application/json"}).post(Entity.entity((Object)assetStream, (MediaType)GitHubRepo.fileType(assetFile)));){
            assetInfo = (GitHubApi.ReleaseAssetInfo)response.readEntity(GitHubApi.ReleaseAssetInfo.class);
        }
        return assetInfo;
    }

    public void deleteRelease(String releaseId) throws IOException {
        this.setupClientIfNeeded();
        ProjectLogger.info("Deleting release '{}/{}/{}'...", this.owner, this.repo, releaseId);
        try {
            this.apiHolder.get().deleteRelease(this.owner, this.repo, releaseId);
        }
        catch (NotFoundException e) {
            ProjectLogger.trace("Ignoring exception", e);
        }
        catch (ClientErrorException e) {
            throw new IOException("Failed to delete release '" + releaseId + "'", e);
        }
    }

    @Override
    public synchronized void close() {
        this.clientHolder.getOptional().ifPresent(Client::close);
    }

    private synchronized void setupClientIfNeeded() throws IOException {
        if (!this.clientHolder.getOptional().isPresent()) {
            try {
                ClientBuilder clientBuilder = (ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(ApiVersionV3.class)).register(ApiAuthorization.class)).register(ApiStatus.class);
                Client client = this.clientHolder.set(clientBuilder.build());
                client.property(ApiAuthorization.class.getName(), (Object)("token " + this.token));
                GitHubApi api = (GitHubApi)WebResourceFactory.newResource(GitHubApi.class, (WebTarget)client.target(new URI(GITHUB_API_BASE_URI)));
                this.apiHolder.set(api);
            }
            catch (URISyntaxException e) {
                throw new IOException("Invalid GitHub API Base URI: https://api.github.com", e);
            }
        }
    }

    private static MediaType fileType(File file) {
        String fileName = file.getName();
        int fileTypeIndex = 0;
        String fileType = null;
        while (fileType == null) {
            if (fileName.endsWith(FILE_TYPE_MAP[fileTypeIndex])) {
                fileType = FILE_TYPE_MAP[fileTypeIndex + 1];
            }
            fileTypeIndex += 2;
        }
        return MediaType.valueOf(fileType);
    }

    private static class ApiStatus
    implements ClientResponseFilter {
        private ApiStatus() {
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
            if (Response.Status.Family.CLIENT_ERROR == responseContext.getStatusInfo().getFamily() && MediaType.APPLICATION_JSON_TYPE.equals((Object)responseContext.getMediaType()) && responseContext.hasEntity()) {
                GitHubApi.ResponseStatus responseStatus = (GitHubApi.ResponseStatus)new ObjectMapper().readValue(responseContext.getEntityStream(), GitHubApi.ResponseStatus.class);
                throw new IOException("Api call to " + responseContext.getLocation() + "failed with message '" + responseStatus.message + "' (" + responseStatus.documentationUrl + ")");
            }
        }
    }

    private static class ApiAuthorization
    implements ClientRequestFilter {
        private ApiAuthorization() {
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            requestContext.getHeaders().add((Object)"Authorization", requestContext.getClient().getConfiguration().getProperty(ApiAuthorization.class.getName()));
        }
    }

    private static class ApiVersionV3
    implements ClientRequestFilter {
        private ApiVersionV3() {
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            requestContext.getHeaders().add((Object)"Accept", (Object)"application/vnd.github.v3+json");
        }
    }
}

