/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.ext.JavaToolsExtension;
import de.carne.gradle.plugin.java.ext.Node;
import de.carne.gradle.plugin.java.task.NodeTask;
import de.carne.gradle.plugin.java.util.NpmWrapper;
import de.carne.gradle.plugin.java.util.Plugins;
import de.carne.gradle.plugin.java.util.ProjectLogger;
import de.carne.gradle.plugin.java.util.Strings;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;

public class NpmTestTask
extends NodeTask {
    private static final String NPM_TEST_TASK_GROUP = "verification";
    private static final String NPM_TEST_TASK_NAME = "npmTest";
    private static final String NPM_TEST_TASK_DESCRIPTION = "Execute npm test script.";

    public static NpmTestTask create(Project project) {
        project.getLogger().info("Creating task {}", (Object)NPM_TEST_TASK_NAME);
        return (NpmTestTask)project.getTasks().create(NPM_TEST_TASK_NAME, NpmTestTask.class);
    }

    @Override
    public void apply(Project project) {
        this.setGroup(NPM_TEST_TASK_GROUP);
        this.setDescription(NPM_TEST_TASK_DESCRIPTION);
    }

    @Override
    public void afterEvaluate(Project project) {
        super.afterEvaluate(project);
        Node node = ((JavaToolsExtension)project.getExtensions().getByType(JavaToolsExtension.class)).getNode();
        boolean enabled = node.isEnabled();
        if (enabled) {
            this.getInputs().dir((Object)node.getNodeProjectDir());
            this.getOutputs().file((Object)this.taskOutFile());
            Plugins.setTaskDependsOn(project, "check", (Task)this);
        }
    }

    @TaskAction
    public void executeNpmTest() {
        Project project = this.getProject();
        ProjectLogger.enterProject(project);
        try {
            Node node = ((JavaToolsExtension)project.getExtensions().getByType(JavaToolsExtension.class)).getNode();
            String testScript = node.getTestScript();
            if (Strings.notEmpty(testScript)) {
                NpmWrapper npmWrapper = this.npmWrapperInstance();
                File logFile = this.taskOutFile();
                npmWrapper.executeNpm(logFile, "--verbose", "run", testScript);
            }
        }
        catch (IOException e) {
            throw new TaskExecutionException((Task)this, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TaskExecutionException((Task)this, (Throwable)e);
        }
        finally {
            ProjectLogger.leaveProject();
        }
    }
}

