/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.ext.JavaToolsExtension;
import de.carne.gradle.plugin.java.ext.Node;
import de.carne.gradle.plugin.java.task.NodeTask;
import de.carne.gradle.plugin.java.task.NpmBuildTask;
import de.carne.gradle.plugin.java.task.NpmTestTask;
import de.carne.gradle.plugin.java.util.NpmWrapper;
import de.carne.gradle.plugin.java.util.Plugins;
import de.carne.gradle.plugin.java.util.ProjectLogger;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;

public class NpmInstallTask
extends NodeTask {
    private static final String NPM_INSTALL_TASK_GROUP = "build";
    private static final String NPM_INSTALL_TASK_NAME = "npmInstall";
    private static final String NPM_INSTALL_TASK_DESCRIPTION = "Execute npm install.";

    public static NpmInstallTask create(Project project) {
        project.getLogger().info("Creating task {}", (Object)NPM_INSTALL_TASK_NAME);
        return (NpmInstallTask)project.getTasks().create(NPM_INSTALL_TASK_NAME, NpmInstallTask.class);
    }

    @Override
    public void apply(Project project) {
        this.setGroup(NPM_INSTALL_TASK_GROUP);
        this.setDescription(NPM_INSTALL_TASK_DESCRIPTION);
    }

    @Override
    public void afterEvaluate(Project project) {
        super.afterEvaluate(project);
        Node node = ((JavaToolsExtension)project.getExtensions().getByType(JavaToolsExtension.class)).getNode();
        boolean enabled = node.isEnabled();
        if (enabled) {
            this.getInputs().file((Object)this.nodeProjectFile("package.json"));
            this.getInputs().file((Object)this.nodeProjectFile("package-lock.json"));
            this.getOutputs().file((Object)this.taskOutFile());
            this.getOutputs().dir((Object)this.nodeProjectFile("node_modules"));
            Plugins.setTasksDependsOn(project, NpmBuildTask.class, (Task)this);
            Plugins.setTasksDependsOn(project, NpmTestTask.class, (Task)this);
        }
    }

    @TaskAction
    public void executeNpmInstall() {
        Project project = this.getProject();
        ProjectLogger.enterProject(project);
        try {
            NpmWrapper npmWrapper = this.npmWrapperInstance();
            File logFile = this.taskOutFile();
            npmWrapper.executeNpm(logFile, "--verbose", "install");
        }
        catch (IOException e) {
            throw new TaskExecutionException((Task)this, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TaskExecutionException((Task)this, (Throwable)e);
        }
        finally {
            ProjectLogger.leaveProject();
        }
    }
}

