/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.ext.JavaToolsExtension;
import de.carne.gradle.plugin.java.ext.Node;
import de.carne.gradle.plugin.java.task.NodeTask;
import de.carne.gradle.plugin.java.util.NpmWrapper;
import de.carne.gradle.plugin.java.util.Plugins;
import de.carne.gradle.plugin.java.util.ProjectLogger;
import de.carne.gradle.plugin.java.util.Strings;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;

public class NpmBuildTask
extends NodeTask {
    private static final String NPM_BUILD_TASK_GROUP = "build";
    private static final String NPM_BUILD_TASK_NAME = "npmBuild";
    private static final String NPM_BUILD_TASK_DESCRIPTION = "Execute npm build script.";

    public static NpmBuildTask create(Project project) {
        project.getLogger().info("Creating task {}", (Object)NPM_BUILD_TASK_NAME);
        return (NpmBuildTask)project.getTasks().create(NPM_BUILD_TASK_NAME, NpmBuildTask.class);
    }

    @Override
    public void apply(Project project) {
        this.setGroup(NPM_BUILD_TASK_GROUP);
        this.setDescription(NPM_BUILD_TASK_DESCRIPTION);
    }

    @Override
    public void afterEvaluate(Project project) {
        super.afterEvaluate(project);
        Node node = ((JavaToolsExtension)project.getExtensions().getByType(JavaToolsExtension.class)).getNode();
        boolean enabled = node.isEnabled();
        if (enabled) {
            this.getInputs().dir((Object)node.getNodeProjectDir());
            this.getOutputs().file((Object)this.taskOutFile());
            this.getOutputs().dir((Object)node.getNodeDistDir());
            Plugins.setTaskDependsOn(project, "processResources", (Task)this);
        }
    }

    @TaskAction
    public void executeNpmBuild() {
        Project project = this.getProject();
        ProjectLogger.enterProject(project);
        try {
            Node node = ((JavaToolsExtension)project.getExtensions().getByType(JavaToolsExtension.class)).getNode();
            String buildScript = node.getBuildScript();
            if (Strings.notEmpty(buildScript)) {
                NpmWrapper npmWrapper = this.npmWrapperInstance();
                File logFile = this.taskOutFile();
                npmWrapper.executeNpm(logFile, "--verbose", "run", buildScript);
            }
        }
        catch (IOException e) {
            throw new TaskExecutionException((Task)this, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TaskExecutionException((Task)this, (Throwable)e);
        }
        finally {
            ProjectLogger.leaveProject();
        }
    }
}

