/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.ext.JavaToolsExtension;
import de.carne.gradle.plugin.java.ext.Node;
import de.carne.gradle.plugin.java.task.JavaToolsTask;
import de.carne.gradle.plugin.java.util.NpmWrapper;
import de.carne.gradle.plugin.java.util.Plugins;
import java.io.File;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskExecutionException;

public abstract class NodeTask
extends DefaultTask
implements JavaToolsTask {
    protected static final String PACKAGE_JSON_NAME = "package.json";
    protected static final String PACKAGE_LOCK_JSON_NAME = "package-lock.json";
    protected static final String NODE_MODULES_NAME = "node_modules";

    @Override
    public void afterEvaluate(Project project) {
        Node node = ((JavaToolsExtension)project.getExtensions().getByType(JavaToolsExtension.class)).getNode();
        boolean enabled = node.isEnabled();
        this.setEnabled(enabled);
        if (enabled) {
            Plugins.checkJavaApplied(project);
        }
    }

    protected NpmWrapper npmWrapperInstance() throws IOException, InterruptedException {
        Node node = ((JavaToolsExtension)this.getProject().getExtensions().getByType(JavaToolsExtension.class)).getNode();
        NpmWrapper npmWrapper = NpmWrapper.getInstance(node.getNodeProjectDir(), node.getNpmCommand());
        String npmVersion = npmWrapper.npmVersion();
        String requiredNpmVersion = node.getNpmVersion();
        if (!npmVersion.matches(node.getNpmVersion())) {
            throw new TaskExecutionException((Task)this, (Throwable)new IllegalArgumentException("Invalid npm version: " + npmVersion + " (required: " + requiredNpmVersion + ")"));
        }
        return npmWrapper;
    }

    protected File nodeProjectFile(String name) {
        return new File(((JavaToolsExtension)this.getProject().getExtensions().getByType(JavaToolsExtension.class)).getNode().getNodeProjectDir(), name);
    }

    protected File taskOutFile() {
        return new File(this.getProject().getBuildDir(), this.getName() + ".out");
    }
}

