/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.ext.GitHubRelease;
import de.carne.gradle.plugin.java.ext.JavaToolsExtension;
import de.carne.gradle.plugin.java.task.JavaToolsTask;
import de.carne.gradle.plugin.java.util.GitHubApi;
import de.carne.gradle.plugin.java.util.GitHubRepo;
import de.carne.gradle.plugin.java.util.ProjectLogger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;

public class DraftGitHubReleaseTask
extends DefaultTask
implements JavaToolsTask {
    private static final String DRAFT_GITHUB_RELEASE_TASK_GROUP = "distribute";
    private static final String DRAFT_GITHUB_RELEASE_TASK_NAME = "draftGitHubRelease";
    private static final String DRAFT_GITHUB_RELEASE_TASK_DESCRIPTION = "Draft new GitHub release.";

    public static DraftGitHubReleaseTask create(Project project) {
        project.getLogger().info("Creating task draftGitHubRelease");
        return (DraftGitHubReleaseTask)project.getTasks().create(DRAFT_GITHUB_RELEASE_TASK_NAME, DraftGitHubReleaseTask.class);
    }

    @Override
    public void apply(Project project) {
        this.setGroup(DRAFT_GITHUB_RELEASE_TASK_GROUP);
        this.setDescription(DRAFT_GITHUB_RELEASE_TASK_DESCRIPTION);
    }

    @Override
    public void afterEvaluate(Project project) {
        GitHubRelease githubRelease = ((JavaToolsExtension)project.getExtensions().getByType(JavaToolsExtension.class)).getGithubRelease();
        this.setEnabled(githubRelease.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void executeDraftGitHubRelease() {
        Project project = this.getProject();
        ProjectLogger.enterProject(project);
        try {
            File repoDir = this.getRepoDir(project.getProjectDir());
            GitHubRelease githubRelease = ((JavaToolsExtension)project.getExtensions().getByType(JavaToolsExtension.class)).getGithubRelease();
            String releaseName = githubRelease.getReleaseName();
            this.getLogger().lifecycle("Drafting release {} for repo '{}'...", new Object[]{releaseName, repoDir});
            try (GitHubRepo repo = new GitHubRepo(repoDir, githubRelease.getGithubToken());){
                this.checkDirty(repo, githubRelease);
                this.checkOverwrite(repo, githubRelease);
                String releaseNotes = this.readReleaseNotes(githubRelease);
                GitHubApi.ReleaseInfo draft = repo.draftRelease(githubRelease.getReleaseName(), releaseNotes);
                ConfigurableFileTree releaseAssets = githubRelease.getReleaseAssets();
                for (File releaseAsset : releaseAssets.getFiles()) {
                    this.getLogger().lifecycle("Uploading release asset '{}'...", new Object[]{releaseAsset});
                    repo.uploadReleaseAsset(Objects.requireNonNull(draft.uploadUrl), releaseAsset);
                }
            }
            catch (IOException e) {
                throw new TaskExecutionException((Task)this, (Throwable)e);
            }
        }
        finally {
            ProjectLogger.leaveProject();
        }
    }

    private File getRepoDir(File projectDir) {
        File repoDir;
        for (repoDir = projectDir; repoDir != null && !new File(repoDir, ".git").isDirectory(); repoDir = repoDir.getParentFile()) {
        }
        return repoDir != null ? repoDir : projectDir;
    }

    private void checkDirty(GitHubRepo repo, GitHubRelease githubRelease) throws IOException {
        if (!githubRelease.isIgnoreDirty() && repo.isDirty()) {
            throw new IOException("Repo at '" + repo.dir() + "' has uncomitted or untracked changes; either clean repo or set ignoreDiry");
        }
    }

    private void checkOverwrite(GitHubRepo repo, GitHubRelease githubRelease) throws IOException {
        String releaseName = githubRelease.getReleaseName();
        GitHubApi.ReleaseInfo releaseInfo = repo.queryRelease(releaseName);
        if (releaseInfo != null) {
            if (!githubRelease.isOverwrite()) {
                throw new IOException("Release '" + releaseName + "' already exists");
            }
            if (!releaseInfo.draft) {
                throw new IOException("Release '" + releaseName + "' already published");
            }
            repo.deleteRelease(Objects.requireNonNull(releaseInfo.id));
        }
    }

    private String readReleaseNotes(GitHubRelease githubRelease) throws IOException {
        return new String(Files.readAllBytes(githubRelease.getReleaseNotes().toPath()), StandardCharsets.UTF_8);
    }
}

