/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.task.ArtifactId;
import de.carne.gradle.plugin.java.task.ArtifactVersionId;
import de.carne.gradle.plugin.java.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class DependencyKey
implements Comparable<DependencyKey> {
    private final String projectName;
    private final String configurationName;
    private final String dependencyGroup;
    private final String dependencyName;
    private final String dependencyVersion;
    private final List<Object> sortKey = new ArrayList<Object>();
    private static final Pattern DEPENDENCY_VERSION_TOKEN_PATTERN = Pattern.compile("(\\d*)(.*)");

    DependencyKey(String projectName, String configurationName, String dependencyGroup, String dependencyName, @Nullable String dependencyVersion) {
        this.projectName = projectName;
        this.configurationName = configurationName;
        this.dependencyGroup = dependencyGroup;
        this.dependencyName = dependencyName;
        this.dependencyVersion = Strings.safe(dependencyVersion);
        this.initSortKey();
    }

    private void initSortKey() {
        this.sortKey.add(this.projectName);
        this.sortKey.add(this.configurationName);
        this.sortKey.add(this.dependencyGroup);
        this.sortKey.add(this.dependencyName);
        StringTokenizer tokens = new StringTokenizer(this.dependencyVersion, ".", false);
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            Matcher tokenMatcher = DEPENDENCY_VERSION_TOKEN_PATTERN.matcher(token);
            if (tokenMatcher.lookingAt()) {
                String tokenDigits = Objects.requireNonNull(tokenMatcher.group(1));
                String tokenSuffix = Objects.requireNonNull(tokenMatcher.group(2));
                try {
                    Integer tokenValue = Integer.parseInt(tokenDigits);
                    this.sortKey.add(tokenValue);
                    this.sortKey.add(tokenSuffix);
                }
                catch (NumberFormatException e) {
                    this.sortKey.add(token);
                    this.sortKey.add("");
                }
                continue;
            }
            this.sortKey.add(token);
            this.sortKey.add("");
        }
    }

    public String getProject() {
        return this.projectName;
    }

    public String getConfiguration() {
        return this.configurationName;
    }

    public ArtifactId getArtifactId() {
        return new ArtifactId(this.dependencyGroup, this.dependencyName);
    }

    public ArtifactVersionId getArtifactVersionId() {
        return new ArtifactVersionId(this.dependencyGroup, this.dependencyName, this.dependencyVersion);
    }

    @Override
    public int compareTo(@NonNull DependencyKey o) {
        Iterator<Object> thisTokens = this.sortKey.iterator();
        Iterator<Object> oTokens = o.sortKey.iterator();
        int comparison = 0;
        while (comparison == 0 && (thisTokens.hasNext() || oTokens.hasNext())) {
            Object oToken;
            Object thisToken = thisTokens.hasNext() ? thisTokens.next() : "";
            Object object = oToken = oTokens.hasNext() ? oTokens.next() : "";
            if (thisToken instanceof Integer && oToken instanceof Integer) {
                comparison = ((Integer)thisToken).compareTo((Integer)oToken);
                continue;
            }
            comparison = thisToken.toString().compareTo(oToken.toString());
        }
        return comparison;
    }

    public int hashCode() {
        return Objects.hash(this.projectName, this.configurationName, this.dependencyGroup, this.dependencyName, this.dependencyVersion);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof DependencyKey && this.compareTo((DependencyKey)obj) == 0;
    }

    public String toString() {
        return this.projectName + ":" + this.configurationName + ":" + this.dependencyGroup + ":" + this.dependencyName + ":" + this.dependencyVersion;
    }
}

