/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.task.ArtifactId;
import de.carne.gradle.plugin.java.task.ArtifactVersionId;
import de.carne.gradle.plugin.java.task.CheckDependencyVersionsReport;
import de.carne.gradle.plugin.java.task.DependencyKey;
import de.carne.gradle.plugin.java.task.DependencyMap;
import de.carne.gradle.plugin.java.task.JavaToolsTask;
import de.carne.gradle.plugin.java.util.ProjectLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.tasks.TaskAction;

public class CheckDependencyVersionsTask
extends DefaultTask
implements JavaToolsTask {
    private static final String CHECK_DEPENDENCY_VERSIONS_TASK_GROUP = "help";
    private static final String CHECK_DEPENDENCY_VERSIONS_TASK_NAME = "checkDependencyVersions";
    private static final String CHECK_DEPENDENCY_VERSIONS_TASK_DESCRIPTION = "Check for dependency version updates.";
    private static final String CHECK_BUILDSCRIPT_DEPENDENCY_VERSIONS_CONFIGURATION_NAME = "checkBuildscriptDependencyVersions";
    private static final String CHECK_PROJECT_DEPENDENCY_VERSIONS_CONFIGURATION_NAME = "checkProjectDependencyVersions";
    private static final String CHECK_BUILDSCRIPT_DEPENDENCY_VERSIONS_REPORT_TITLE = "Buildscript dependency version check result:";
    private static final String CHECK_PROJECT_DEPENDENCY_VERSIONS_REPORT_TITLE = "Project dependency version check result:";

    public static CheckDependencyVersionsTask create(Project project) {
        project.getLogger().info("Creating task checkDependencyVersions");
        return (CheckDependencyVersionsTask)project.getTasks().create(CHECK_DEPENDENCY_VERSIONS_TASK_NAME, CheckDependencyVersionsTask.class);
    }

    @Override
    public void apply(Project project) {
        this.setGroup(CHECK_DEPENDENCY_VERSIONS_TASK_GROUP);
        this.setDescription(CHECK_DEPENDENCY_VERSIONS_TASK_DESCRIPTION);
        ((Configuration)project.getBuildscript().getConfigurations().create(CHECK_BUILDSCRIPT_DEPENDENCY_VERSIONS_CONFIGURATION_NAME)).setVisible(false).setTransitive(false);
        ((Configuration)project.getConfigurations().create(CHECK_PROJECT_DEPENDENCY_VERSIONS_CONFIGURATION_NAME)).setVisible(false).setTransitive(false);
    }

    @TaskAction
    public void executeCheckDependencyVersions() {
        Project project = this.getProject();
        ProjectLogger.enterProject(project);
        try {
            this.executeCheckDependencyVersions(DependencyMap.fromBuildscript(project), Objects.requireNonNull((Configuration)project.getBuildscript().getConfigurations().findByName(CHECK_BUILDSCRIPT_DEPENDENCY_VERSIONS_CONFIGURATION_NAME)), new CheckDependencyVersionsReport(project, CHECK_BUILDSCRIPT_DEPENDENCY_VERSIONS_REPORT_TITLE));
            this.executeCheckDependencyVersions(DependencyMap.fromProject(project), Objects.requireNonNull((Configuration)project.getConfigurations().findByName(CHECK_PROJECT_DEPENDENCY_VERSIONS_CONFIGURATION_NAME)), new CheckDependencyVersionsReport(project, CHECK_PROJECT_DEPENDENCY_VERSIONS_REPORT_TITLE));
        }
        finally {
            ProjectLogger.leaveProject();
        }
    }

    private void executeCheckDependencyVersions(DependencyMap dependencyMap, Configuration cdvConfiguration, CheckDependencyVersionsReport report) {
        for (Map.Entry dependencyMapEntry : dependencyMap.entrySet()) {
            DependencyKey dependencyMapEntryKey = (DependencyKey)dependencyMapEntry.getKey();
            ArtifactVersionId dependencyArtifactVersionId = dependencyMapEntryKey.getArtifactVersionId();
            String dependencyArtifactIdString = dependencyArtifactVersionId.getArtifactId().toString();
            this.getProject().getLogger().info("Checking latest version for dependency {}...", (Object)dependencyArtifactIdString);
            String artifactDependencyString = dependencyArtifactIdString + (dependencyArtifactVersionId.isSnapshot() ? ":latest.integration" : ":latest.release");
            Dependency artifactDependency = this.getProject().getDependencies().create((Object)artifactDependencyString);
            cdvConfiguration.getDependencies().add((Object)artifactDependency);
        }
        cdvConfiguration.resolutionStrategy(resolutionStrategy -> resolutionStrategy.componentSelection(componentSelectionRules -> componentSelectionRules.all(componentSelection -> this.filterComponentenSelection(dependencyMap, (ComponentSelection)componentSelection))));
        LenientConfiguration resolvedCdvConfiguration = cdvConfiguration.getResolvedConfiguration().getLenientConfiguration();
        Map<ArtifactId, ResolvedArtifact> resolvedArtifactsMap = this.buildResolvedArtifactsMap(resolvedCdvConfiguration.getArtifacts());
        this.evalDependencyVersions(dependencyMap, resolvedArtifactsMap, report);
    }

    private void evalDependencyVersions(DependencyMap dependencyMap, Map<ArtifactId, ResolvedArtifact> resolvedArtifactsMap, CheckDependencyVersionsReport report) {
        for (Map.Entry dependencyMapEntry : dependencyMap.entrySet()) {
            ArtifactVersionId resolvedArtifactVersionId;
            DependencyKey dependencyMapEntryKey = (DependencyKey)dependencyMapEntry.getKey();
            ArtifactVersionId dependencyArtifactVersionId = dependencyMapEntryKey.getArtifactVersionId();
            ResolvedArtifact resolvedArtifact = resolvedArtifactsMap.get(dependencyArtifactVersionId.getArtifactId());
            if (resolvedArtifact == null || dependencyArtifactVersionId.compareTo(resolvedArtifactVersionId = this.getResolvedArtifactVersionId(resolvedArtifact)) == 0) continue;
            report.reportDependencyMismatch(dependencyMapEntryKey.getProject(), dependencyMapEntryKey.getConfiguration(), dependencyArtifactVersionId, resolvedArtifactVersionId);
        }
    }

    private void filterComponentenSelection(DependencyMap dependencyMap, ComponentSelection componentSelection) {
        ArtifactVersionId candidateArtifactVersionId = this.getCandidateArtifactVersionId(componentSelection.getCandidate());
        if (dependencyMap.keySet().stream().map(DependencyKey::getArtifactVersionId).noneMatch(dependencyArtifactVersionId -> dependencyArtifactVersionId.isCandidate(candidateArtifactVersionId))) {
            componentSelection.reject("Ignoring candidate " + candidateArtifactVersionId);
        }
    }

    private Map<ArtifactId, ResolvedArtifact> buildResolvedArtifactsMap(Set<ResolvedArtifact> artifacts) {
        HashMap<ArtifactId, ResolvedArtifact> resolvedArtifactsMap = new HashMap<ArtifactId, ResolvedArtifact>();
        for (ResolvedArtifact artifact : artifacts) {
            resolvedArtifactsMap.put(this.getResolvedArtifactId(artifact), artifact);
        }
        return resolvedArtifactsMap;
    }

    private ArtifactId getResolvedArtifactId(ResolvedArtifact artifact) {
        ModuleVersionIdentifier artifactIdentifier = artifact.getModuleVersion().getId();
        return new ArtifactId(artifactIdentifier.getGroup(), artifactIdentifier.getName());
    }

    private ArtifactVersionId getResolvedArtifactVersionId(ResolvedArtifact artifact) {
        ModuleVersionIdentifier artifactIdentifier = artifact.getModuleVersion().getId();
        return new ArtifactVersionId(artifactIdentifier.getGroup(), artifactIdentifier.getName(), artifactIdentifier.getVersion());
    }

    private ArtifactVersionId getCandidateArtifactVersionId(ModuleComponentIdentifier candidate) {
        return new ArtifactVersionId(candidate.getGroup(), candidate.getModule(), candidate.getVersion());
    }
}

