/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.task.ArtifactVersionId;
import org.eclipse.jdt.annotation.Nullable;
import org.gradle.api.Project;

class CheckDependencyVersionsReport {
    private final Project project;
    private final String title;
    private @Nullable String lastProjectName = null;
    private @Nullable String lastConfigurationName = null;

    public CheckDependencyVersionsReport(Project project, String title) {
        this.project = project;
        this.title = title;
    }

    public void reportDependencyMismatch(String projectName, String configurationName, ArtifactVersionId actual, ArtifactVersionId found) {
        this.writeContext(projectName, configurationName);
        this.write("      Dependency mismatch: %1$s -> %2$s", actual, found);
    }

    private void writeContext(String projectName, String configurationName) {
        if (!projectName.equals(this.lastProjectName)) {
            if (this.lastProjectName == null) {
                this.write(this.title, new Object[0]);
            }
            this.lastProjectName = projectName;
            this.lastConfigurationName = null;
            this.write("  Project %1$s", this.lastProjectName);
        }
        if (!configurationName.equals(this.lastConfigurationName)) {
            this.lastConfigurationName = configurationName;
            this.write("    Configuration %1$s", this.lastConfigurationName);
        }
    }

    private String write(String format, Object ... args) {
        String message = String.format(format, args);
        this.project.getLogger().warn(message);
        return message;
    }
}

