/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.task;

import de.carne.gradle.plugin.java.task.ArtifactId;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

class ArtifactVersionId
implements Comparable<ArtifactVersionId> {
    private final ArtifactId artifactId;
    private final String version;

    public ArtifactVersionId(String group, String name, String version) {
        this.artifactId = new ArtifactId(group, name);
        this.version = version;
    }

    public ArtifactId getArtifactId() {
        return this.artifactId;
    }

    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public boolean isQualified() {
        return this.version.contains("-");
    }

    public boolean isCandidate(ArtifactVersionId artifactVersionId) {
        return !(!this.artifactId.equals(artifactVersionId.artifactId) || artifactVersionId.isSnapshot() && !this.isSnapshot() || artifactVersionId.isQualified() && !this.isQualified());
    }

    @Override
    public int compareTo(ArtifactVersionId o) {
        int comparison = 0;
        comparison = this.artifactId.compareTo(o.artifactId);
        if (comparison == 0) {
            comparison = this.version.compareTo(o.version);
        }
        return comparison;
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.version);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof ArtifactVersionId && this.compareTo((ArtifactVersionId)obj) == 0;
    }

    public String toString() {
        return this.artifactId + ":" + this.version;
    }
}

