/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java.ext;

import de.carne.gradle.plugin.java.util.Platform;

public class PlatformInfo {
    public boolean isIsLinux() {
        return Platform.IS_LINUX;
    }

    public boolean isIsMacos() {
        return Platform.IS_MACOS;
    }

    public boolean isIsWindows() {
        return Platform.IS_WINDOWS;
    }

    public String getSwtToolkit() {
        StringBuilder toolkit = new StringBuilder();
        if (Platform.IS_LINUX) {
            toolkit.append("gtk-linux");
        } else if (Platform.IS_MACOS) {
            toolkit.append("cocoa-macosx");
        } else if (Platform.IS_WINDOWS) {
            toolkit.append("win32-win32");
        } else {
            toolkit.append("unknown-unknown");
        }
        if ("x86".equals(Platform.SYSTEM_OS_ARCH) || "x86_32".equals(Platform.SYSTEM_OS_ARCH)) {
            toolkit.append("-x86");
        } else if ("x86_64".equals(Platform.SYSTEM_OS_ARCH) || "amd64".equals(Platform.SYSTEM_OS_ARCH)) {
            toolkit.append("-x86_64");
        } else {
            toolkit.append("unknown");
        }
        return toolkit.toString();
    }
}

