/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradle.plugin.java;

import de.carne.gradle.plugin.java.ext.JavaToolsExtension;
import de.carne.gradle.plugin.java.task.CheckDependencyVersionsTask;
import de.carne.gradle.plugin.java.task.DraftGitHubReleaseTask;
import de.carne.gradle.plugin.java.task.GenerateI18NTask;
import de.carne.gradle.plugin.java.task.NpmBuildTask;
import de.carne.gradle.plugin.java.task.NpmInstallTask;
import de.carne.gradle.plugin.java.task.NpmTestTask;
import de.carne.gradle.plugin.java.util.Late;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class JavaToolsPlugin
implements Plugin<Project> {
    public static final String JAVA_TOOLS_PLUGIN_NAME = "de.carne.java-tools";
    private final Late<GenerateI18NTask> generateI18NTaskHolder = new Late();
    private final Late<CheckDependencyVersionsTask> checkDependencyVersionsTaskHolder = new Late();
    private final Late<DraftGitHubReleaseTask> draftGitHubReleaseTaskHolder = new Late();
    private final Late<NpmInstallTask> npmInstallTaskHolder = new Late();
    private final Late<NpmBuildTask> npmBuildTaskHolder = new Late();
    private final Late<NpmTestTask> npmTestTaskHolder = new Late();

    public void apply(@Nullable Project project) {
        Objects.requireNonNull(project);
        JavaToolsExtension.create(project);
        this.generateI18NTaskHolder.set(GenerateI18NTask.create(project)).apply(project);
        this.checkDependencyVersionsTaskHolder.set(CheckDependencyVersionsTask.create(project)).apply(project);
        this.draftGitHubReleaseTaskHolder.set(DraftGitHubReleaseTask.create(project)).apply(project);
        this.npmInstallTaskHolder.set(NpmInstallTask.create(project)).apply(project);
        this.npmBuildTaskHolder.set(NpmBuildTask.create(project)).apply(project);
        this.npmTestTaskHolder.set(NpmTestTask.create(project)).apply(project);
        project.afterEvaluate(this::afterEvaluate);
    }

    private void afterEvaluate(@Nullable Project project) {
        Objects.requireNonNull(project);
        this.generateI18NTaskHolder.get().afterEvaluate(project);
        this.checkDependencyVersionsTaskHolder.get().afterEvaluate(project);
        this.draftGitHubReleaseTaskHolder.get().afterEvaluate(project);
        this.npmInstallTaskHolder.get().afterEvaluate(project);
        this.npmBuildTaskHolder.get().afterEvaluate(project);
        this.npmTestTaskHolder.get().afterEvaluate(project);
    }
}

