/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.zip;

import de.carne.filescanner.engine.format.CharArraySpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.EncodedInputSpecConfig;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.format.WordSpec;
import de.carne.filescanner.engine.input.InputDecoderTable;
import de.carne.filescanner.engine.input.InputDecoders;
import de.carne.filescanner.engine.util.DeflateInputDecoder;
import de.carne.filescanner.engine.util.HexFormat;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.Objects;

final class ZipFormatSpecDefinition
extends FormatSpecDefinition {
    private static final DeflateInputDecoder DEFLATE_INPUT_DECODER = new DeflateInputDecoder();
    private Lazy<CompositeSpec> zipFormatSpec = this.resolveLazy("ZIP_ARCHIVE", CompositeSpec.class);
    private Lazy<CompositeSpec> lfhSpec = this.resolveLazy("LOCAL_FILE_HEADER", CompositeSpec.class);
    private Lazy<CompositeSpec> ddSpec = this.resolveLazy("DATA_DESCRIPTOR", CompositeSpec.class);
    private Lazy<WordSpec> lfhGenerapPurposeBitFlag = this.resolveLazy("LFH_GENERAL_PURPOSE_BIT_FLAG", WordSpec.class);
    private Lazy<WordSpec> lfhCompressionMethod = this.resolveLazy("LFH_COMPRESSION_METHOD", WordSpec.class);
    private Lazy<DWordSpec> lfhCompressedSize = this.resolveLazy("LFH_COMPRESSED_SIZE", DWordSpec.class);
    private Lazy<CharArraySpec> lfhFileName = this.resolveLazy("LFH_FILE_NAME", CharArraySpec.class);

    ZipFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("Zip.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.zipFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.lfhSpec.get();
    }

    public EncodedInputSpecConfig zipEntryEncodedInputConfig() {
        return new EncodedInputSpecConfig("file data").inputDecoderTable(this::inputDecoderTable).decodedInputName(this::decodedInputName);
    }

    private long encodedInputSize() {
        return Integer.toUnsignedLong((Integer)((DWordSpec)this.lfhCompressedSize.get()).get());
    }

    private long optionalEncodedInputSize() {
        int bitFlag = Short.toUnsignedInt((Short)((WordSpec)this.lfhGenerapPurposeBitFlag.get()).get());
        boolean ddPresent = (bitFlag & 8) != 0;
        return ddPresent ? -1L : Integer.toUnsignedLong((Integer)((DWordSpec)this.lfhCompressedSize.get()).get());
    }

    private InputDecoderTable inputDecoderTable() {
        InputDecoderTable inputDecoderTable;
        short compressionMethod = (Short)((WordSpec)this.lfhCompressionMethod.get()).get();
        switch (compressionMethod) {
            case 0: {
                inputDecoderTable = InputDecoderTable.build(InputDecoders.IDENTITY, -1L, this.encodedInputSize(), -1L);
                break;
            }
            case 8: {
                inputDecoderTable = InputDecoderTable.build(DEFLATE_INPUT_DECODER, -1L, this.optionalEncodedInputSize(), -1L);
                break;
            }
            default: {
                inputDecoderTable = InputDecoderTable.build(InputDecoders.unsupportedInputDecoder("ZIP compression method " + HexFormat.formatShort(compressionMethod)), -1L, this.encodedInputSize(), -1L);
            }
        }
        return inputDecoderTable;
    }

    private String decodedInputName() {
        return (String)((CharArraySpec)this.lfhFileName.get()).get();
    }

    public CompositeSpec dataDescriptorSpec() {
        int bitFlag = Short.toUnsignedInt((Short)((WordSpec)this.lfhGenerapPurposeBitFlag.get()).get());
        boolean ddPresent = (bitFlag & 8) != 0;
        return ddPresent ? (CompositeSpec)this.ddSpec.get() : FormatSpecs.EMPTY;
    }
}

