/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.xml;

import de.carne.filescanner.engine.StreamValue;
import de.carne.filescanner.engine.ValueStreamer;
import de.carne.filescanner.engine.ValueStreamerFactory;
import de.carne.filescanner.engine.ValueStreamerStatus;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.ScanAttributeSpec;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.RawTransferHandler;
import de.carne.filescanner.engine.transfer.handler.StyledTextRenderHandler;
import de.carne.io.IOUtil;
import de.carne.util.Late;
import de.carne.util.Lazy;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class XmlFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> xmlFormatSpec = this.resolveLazy("XML_STREAM", CompositeSpec.class);
    private Lazy<CompositeSpec> xmlDeclSpec = this.resolveLazy("XML_DECL", CompositeSpec.class);
    private Lazy<ScanAttributeSpec> declSpec = this.resolveLazy("DECL", ScanAttributeSpec.class);

    XmlFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("Xml.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.xmlFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.xmlDeclSpec.get();
    }

    public ValueStreamerFactory declScanner() {
        return DeclScanner::new;
    }

    public FileScannerResultRenderHandler xmlRenderer() throws IOException {
        Charset charset = DeclScanner.streamCharset(((StreamValue)((ScanAttributeSpec)this.declSpec.get()).get()).stream());
        return StyledTextRenderHandler.xmlRenderHandler(charset);
    }

    public FileScannerResultExportHandler xmlExporter() {
        return RawTransferHandler.TEXT_XML_TRANSFER;
    }

    private static final class DeclScanner
    implements ValueStreamer {
        private static final Log LOG = new Log();
        private static final int SIGNATURE_BYTE_ENCODING = 1836597052;
        private static final int SIGNATURE_UTF8_ENCODING = 1019198447;
        private static final int SIGNATURE_UTF16LE_ENCODING = 3997694;
        private static final int SIGNATURE_UTF16BE_ENCODING = 1006698239;
        private static final Pattern PATTERN_XML_DECL = Pattern.compile("<\\?xml version=\"[^\"]*\"( encoding=\"([^\"]*)\")?.*\\?>");
        private final Late<CharsetDecoder> decoderHolder = new Late();
        private String decodedCharsetName = StandardCharsets.UTF_8.name();
        private int bytesPerChar = 0;
        private final CharBuffer decodeBuffer = CharBuffer.allocate(256);
        private boolean decodeBufferUnderflow = false;
        private StepFunction step = this::streamInit;

        DeclScanner() {
        }

        public static Charset streamCharset(InputStream stream) throws IOException {
            Charset charset;
            DeclScanner scanner = new DeclScanner();
            ByteBuffer buffer = ByteBuffer.wrap(IOUtil.readAllBytes((InputStream)stream));
            ValueStreamerStatus streamStatus = scanner.stream(buffer);
            if (streamStatus != ValueStreamerStatus.COMPLETE) {
                LOG.warning("Failed to decode XML charset (stream status: {})", new Object[]{streamStatus});
            }
            try {
                charset = Charset.forName(scanner.decodedCharsetName);
            }
            catch (IllegalCharsetNameException e) {
                LOG.warning((Throwable)e, "Failed to instantiate charset ''{0}''", new Object[]{scanner.decodedCharsetName});
                charset = StandardCharsets.UTF_8;
            }
            return charset;
        }

        @Override
        public ValueStreamerStatus stream(ByteBuffer buffer) {
            ValueStreamerStatus status;
            while ((status = this.step.apply(buffer)) == ValueStreamerStatus.STREAMING && buffer.hasRemaining() && !this.decodeBufferUnderflow) {
            }
            return status;
        }

        private ValueStreamerStatus streamInit(ByteBuffer buffer) {
            ValueStreamerStatus status = ValueStreamerStatus.FAILED;
            if (buffer.hasRemaining()) {
                this.step = this::streamSignature;
                status = ValueStreamerStatus.STREAMING;
            }
            return status;
        }

        private ValueStreamerStatus streamSignature(ByteBuffer buffer) {
            ValueStreamerStatus status = ValueStreamerStatus.FAILED;
            if (buffer.remaining() >= 4) {
                byte signature3;
                byte signature2;
                byte signature1;
                byte signature0 = buffer.get();
                int signature = signature0 & 0xFF | ((signature1 = buffer.get()) & 0xFF) << 8 | ((signature2 = buffer.get()) & 0xFF) << 16 | ((signature3 = buffer.get()) & 0xFF) << 24;
                if (signature == 1836597052) {
                    this.initDecoder(StandardCharsets.UTF_8, 1);
                    this.decodeBuffer.append("<?xm");
                    this.step = this::streamDecl;
                    status = ValueStreamerStatus.STREAMING;
                } else if (signature == 1019198447) {
                    this.initDecoder(StandardCharsets.UTF_8, 1);
                    this.decodeBuffer.append("<?");
                    this.step = this::streamDecl;
                    status = ValueStreamerStatus.STREAMING;
                } else if (signature == 3997694) {
                    this.initDecoder(StandardCharsets.UTF_16LE, 2);
                    this.decodeBuffer.append("<");
                    this.step = this::streamDecl;
                    status = ValueStreamerStatus.STREAMING;
                } else if (signature == 1006698239) {
                    this.initDecoder(StandardCharsets.UTF_16BE, 2);
                    this.decodeBuffer.append("<");
                    this.step = this::streamDecl;
                    status = ValueStreamerStatus.STREAMING;
                }
            }
            return status;
        }

        private void initDecoder(Charset charset, int bpc) {
            this.decoderHolder.set((Object)charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
            this.decodedCharsetName = charset.name();
            this.bytesPerChar = bpc;
        }

        private ValueStreamerStatus streamDecl(ByteBuffer buffer) {
            ValueStreamerStatus status;
            int decodeStart = buffer.position();
            CoderResult coderResult = ((CharsetDecoder)this.decoderHolder.get()).decode(buffer, this.decodeBuffer, false);
            String decoded = this.decodeBuffer.duplicate().flip().toString();
            Matcher matcher = PATTERN_XML_DECL.matcher(decoded);
            if (matcher.lookingAt()) {
                String matcherGroup2 = matcher.group(2);
                if (matcherGroup2 != null) {
                    this.decodedCharsetName = matcherGroup2;
                }
                buffer.position(decodeStart + (matcher.end() - 1) * this.bytesPerChar);
                status = ValueStreamerStatus.COMPLETE;
            } else {
                status = ValueStreamerStatus.FAILED;
            }
            this.decodeBufferUnderflow = coderResult.isUnderflow();
            return status;
        }

        private static interface StepFunction {
            public ValueStreamerStatus apply(ByteBuffer var1);
        }
    }
}

