/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.tiff;

import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.DecodeAtSpec;
import de.carne.filescanner.engine.format.FormatSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.format.RangeAttributeSpec;
import de.carne.filescanner.engine.format.StructSpec;
import de.carne.filescanner.engine.format.WordSpec;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.RawTransferHandler;
import de.carne.filescanner.engine.util.IntHelper;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class TiffFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> tiffFormatSpec = this.resolveLazy("TIFF_FORMAT", CompositeSpec.class);
    private Lazy<CompositeSpec> tiffHeaderLESpec = this.resolveLazy("TIFF_HEADER_CLASSIC_LE", CompositeSpec.class);
    private Lazy<CompositeSpec> tiffDirectoryLESpec = this.resolveLazy("TIFF_DIRECTORY_LE", CompositeSpec.class);
    private Lazy<WordSpec> tdirType = this.resolveLazy("TDIR_TYPE", WordSpec.class);
    private Lazy<DWordSpec> tdirCount = this.resolveLazy("TDIR_COUNT", DWordSpec.class);
    private Lazy<DWordSpec> tdirOffset = this.resolveLazy("TDIR_OFFSET", DWordSpec.class);
    private Lazy<DWordSpec> nextDirOff = this.resolveLazy("NEXT_DIR_OFF", DWordSpec.class);

    TiffFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("TIFF.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.tiffFormatSpec.get();
    }

    public List<CompositeSpec> headerSpecs() {
        ArrayList<CompositeSpec> headerSpecs = new ArrayList<CompositeSpec>();
        headerSpecs.add((CompositeSpec)this.tiffHeaderLESpec.get());
        return headerSpecs;
    }

    public FormatSpec directoryEntryLE() {
        int dataType = ((Short)((WordSpec)this.tdirType.get()).get()).intValue();
        int dataCount = (Integer)((DWordSpec)this.tdirCount.get()).get();
        int dataSize = this.calculateDataSize(dataType, dataCount);
        FormatSpec resultSpec = FormatSpecs.EMPTY;
        if (dataSize > 4) {
            long dataOffset = ((Integer)((DWordSpec)this.tdirOffset.get()).get()).longValue();
            StructSpec entrySpec = new StructSpec();
            entrySpec.result("TIFFEntry");
            entrySpec.add(new RangeAttributeSpec("").size(dataSize));
            resultSpec = new DecodeAtSpec(entrySpec).position(dataOffset).level(1);
        }
        return resultSpec;
    }

    private int calculateDataSize(int dataType, int dataCount) {
        int dataSize;
        switch (dataType) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                dataSize = dataCount;
                break;
            }
            case 3: 
            case 8: {
                dataSize = dataCount << 1;
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                dataSize = dataCount << 2;
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                dataSize = dataCount << 3;
                break;
            }
            default: {
                dataSize = -1;
            }
        }
        return dataSize;
    }

    public FormatSpec nextDirectoryLE() {
        FormatSpec nextDirectorySpec;
        Integer nextDirOffValue = (Integer)((DWordSpec)this.nextDirOff.get()).get();
        if (nextDirOffValue != 0) {
            DecodeAtSpec directoryAtSpec = new DecodeAtSpec((CompositeSpec)this.tiffDirectoryLESpec.get());
            directoryAtSpec.position(IntHelper.toUnsignedLong(nextDirOffValue));
            directoryAtSpec.level(1);
            nextDirectorySpec = directoryAtSpec;
        } else {
            nextDirectorySpec = FormatSpecs.EMPTY;
        }
        return nextDirectorySpec;
    }

    public FileScannerResultRenderHandler tiffRenderer() {
        return RawTransferHandler.IMAGE_TIFF_TRANSFER;
    }

    public FileScannerResultExportHandler tiffExporter() {
        return RawTransferHandler.IMAGE_TIFF_TRANSFER;
    }
}

