/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.tar;

import de.carne.filescanner.engine.format.CharArraySpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.EncodedInputSpecConfig;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.input.InputDecoderTable;
import de.carne.filescanner.engine.input.InputDecoders;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.Objects;

final class TarFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> tarFormatSpec = this.resolveLazy("TAR_ARCHIVE", CompositeSpec.class);
    private Lazy<CompositeSpec> tarHeaderSpec = this.resolveLazy("TAR_HEADER", CompositeSpec.class);
    private Lazy<CompositeSpec> tarDataSpec = this.resolveLazy("TAR_DATA", CompositeSpec.class);
    private Lazy<CharArraySpec> headerName = this.resolveLazy("HEADER_NAME", CharArraySpec.class);
    private Lazy<CharArraySpec> headerSize = this.resolveLazy("HEADER_SIZE", CharArraySpec.class);

    TarFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("Tar.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.tarFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.tarHeaderSpec.get();
    }

    public CompositeSpec tarEntryDataSpec() {
        long size = this.getEntryDataSize();
        return size > 0L ? (CompositeSpec)this.tarDataSpec.get() : FormatSpecs.EMPTY;
    }

    public EncodedInputSpecConfig tarDataEncodedInputConfig() {
        return new EncodedInputSpecConfig("data blocks").decodedInputName(((CharArraySpec)this.headerName.get())::getStripped).inputDecoderTable(this::getEntryDataInputDecoderTable);
    }

    public Integer tarDataUnusedSize() {
        return (512 - (int)(this.getEntryDataSize() % 512L)) % 512;
    }

    private InputDecoderTable getEntryDataInputDecoderTable() {
        return InputDecoderTable.build(InputDecoders.IDENTITY, -1L, this.getEntryDataSize(), -1L);
    }

    private long getEntryDataSize() {
        return this.parseValue((String)((CharArraySpec)this.headerSize.get()).get());
    }

    private long parseValue(String string) {
        long value = 0L;
        for (char c : string.toCharArray()) {
            if (c < '0' || '7' < c) break;
            value <<= 3;
            value += (long)(c - 48);
        }
        return value;
    }
}

