/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.macho;

import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.QWordSpec;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.McdTransferHandler;
import de.carne.filescanner.engine.transfer.handler.RangeRenderHandler;
import de.carne.filescanner.engine.transfer.handler.RawTransferHandler;
import de.carne.filescanner.engine.util.IntHelper;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.Objects;

final class MachOFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> machoFormatSpec = this.resolveLazy("MACHO_FORMAT", CompositeSpec.class);
    private Lazy<CompositeSpec> machHeaderSpec = this.resolveLazy("MACH_HEADER_64", CompositeSpec.class);
    private Lazy<DWordSpec> cpuType = this.resolveLazy("CPU_TYPE", DWordSpec.class);
    private Lazy<DWordSpec> sizeOfCmds = this.resolveLazy("SIZE_OF_CMDS", DWordSpec.class);
    private Lazy<DWordSpec> cmdSize = this.resolveLazy("CMD_SIZE", DWordSpec.class);
    private Lazy<DWordSpec> segment64Flags = this.resolveLazy("SEGMENT64_FLAGS", DWordSpec.class);
    private Lazy<QWordSpec> segment64Offset = this.resolveLazy("SEGMENT64_OFFSET", QWordSpec.class);
    private Lazy<QWordSpec> segment64Size = this.resolveLazy("SEGMENT64_SIZE", QWordSpec.class);

    MachOFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("MachO.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.machoFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.machHeaderSpec.get();
    }

    public Long cmdSize() {
        return IntHelper.toUnsignedLong((Number)((DWordSpec)this.cmdSize.get()).get()) - 8L;
    }

    public Long segment64Position() {
        long minOffsetValue = 32L + Integer.toUnsignedLong((Integer)((DWordSpec)this.sizeOfCmds.get()).get());
        long segment64OffsetValue = (Long)((QWordSpec)this.segment64Offset.get()).get();
        return Math.max(minOffsetValue, segment64OffsetValue);
    }

    public Long segment64Size() {
        long segment64SizeValue = (Long)((QWordSpec)this.segment64Size.get()).get();
        long minOffsetValue = 32L + Integer.toUnsignedLong((Integer)((DWordSpec)this.sizeOfCmds.get()).get());
        long segment64OffsetValue = (Long)((QWordSpec)this.segment64Offset.get()).get();
        if (segment64OffsetValue < minOffsetValue) {
            segment64SizeValue = Math.max(segment64SizeValue - (minOffsetValue - segment64OffsetValue), 0L);
        }
        return segment64SizeValue;
    }

    public FileScannerResultRenderHandler segment64Renderer() {
        int cpuTypeValue = (Integer)((DWordSpec)this.cpuType.get()).get();
        int flags = (Integer)((DWordSpec)this.segment64Flags.get()).get();
        FileScannerResultRenderHandler renderer = RangeRenderHandler.RENDER_HANDLER;
        if ((flags & 4) == 4 && cpuTypeValue == 0x1000007) {
            renderer = McdTransferHandler.X86B64_TRANSFER;
        }
        return renderer;
    }

    public FileScannerResultExportHandler segment64Exporter() {
        int cpuTypeValue = (Integer)((DWordSpec)this.cpuType.get()).get();
        int flags = (Integer)((DWordSpec)this.segment64Flags.get()).get();
        FileScannerResultExportHandler exporter = RawTransferHandler.APPLICATION_OCTET_STREAM_TRANSFER;
        if ((flags & 4) == 4 && cpuTypeValue == 0x1000007) {
            exporter = McdTransferHandler.X86B64_TRANSFER;
        }
        return exporter;
    }
}

